/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.roof;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.ai.target.ZombieNearestTargetGoal;
import com.hungteen.pvz.entity.drop.JewelEntity;
import com.hungteen.pvz.entity.misc.DestroyCarEntity;
import com.hungteen.pvz.entity.misc.ElementBallEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class ZomBossEntity
extends PVZZombieEntity {
    private static final DataParameter<Integer> STATES = EntityDataManager.func_187226_a(ZomBossEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final List<Zombies> ZOMBIES_1 = Arrays.asList(Zombies.NORMAL_ZOMBIE, Zombies.NEWSPAPER_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.SNORKEL_ZOMBIE, Zombies.BALLOON_ZOMBIE);
    private static final List<Zombies> ZOMBIES_2 = Arrays.asList(Zombies.CONEHEAD_ZOMBIE, Zombies.POLE_ZOMBIE, Zombies.DANCING_ZOMBIE, Zombies.OLD_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.BALLOON_ZOMBIE, Zombies.POGO_ZOMBIE);
    private static final List<Zombies> ZOMBIES_3 = Arrays.asList(Zombies.BUCKETHEAD_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.ZOMBONI, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.LADDER_ZOMBIE, Zombies.CATAPULT_ZOMBIE);
    private static final List<Zombies> ZOMBIES_4 = Arrays.asList(Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.ZOMBONI, Zombies.LAVA_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR);
    private static final List<Zombies> ZOMBIES_5 = Arrays.asList(Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.SUNDAY_EDITION_ZOMBIE, Zombies.LAVA_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR, Zombies.SAD_GARGANTUAR);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private final int maxPlantsInRange = 40;
    private final int maxZombiesInRange = 30;
    private int summonZombieTick = 0;
    public int shootBallCD = 100;
    public int stealPlantCD = 100;

    public ZomBossEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithZombie = false;
        this.canBeMini = false;
        this.canBeButter = false;
        this.canBeCharm = false;
        this.canBeCold = false;
        this.canBeFrozen = false;
        this.canBeInvis = false;
        this.canBeStealByBungee = false;
        this.hasDirectDefence = true;
        this.maxDeathTime = 60;
        this.resetShootBallCD();
        this.resetStealCD();
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.setDefenceLife(this.getZomBossDefenceLife());
            float range = 50.0f;
            EntityUtil.getAttackEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0)).forEach(target -> {
                if (target instanceof PVZPlantEntity) {
                    target.func_70106_y();
                }
            });
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.ZOMBOSS_LAUGH.get());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATES, (Object)ZomBossStates.NORMAL.ordinal());
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 40.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new ZombieNearestTargetGoal((MobEntity)this, false, 70.0f, 60.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float percent = (this.getDefenceLife() + this.func_110143_aJ()) / (this.func_110138_aP() + this.getZomBossDefenceLife());
        this.bossInfo.func_186735_a(percent);
        if (this.shootBallCD > 0) {
            --this.shootBallCD;
            --this.stealPlantCD;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkAndHeal();
            this.kickEnemiesNearby();
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            ++this.summonZombieTick;
            if (this.summonZombieTick >= this.getSummonZombieCD()) {
                this.summonZombieTick = 0;
                this.summonZombieByBungee();
            }
            if (this.getZomBossState() == ZomBossStates.NORMAL) {
                int flag = this.func_70681_au().nextInt(10);
                if (this.field_70173_aa % 100 == 0 && this.getNearPlantsCount() > this.maxPlantsInRange) {
                    this.setZomBossState(ZomBossStates.CAR);
                } else if (flag < 4 && this.stealPlantCD <= 0) {
                    this.setZomBossState(ZomBossStates.STEAL);
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
                    this.resetStealCD();
                } else if (this.shootBallCD <= 0) {
                    this.setZomBossState(this.func_70681_au().nextInt(2) == 0 ? ZomBossStates.FLAME : ZomBossStates.ICE);
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.ZOMBOSS_SHOOT.get());
                    this.resetShootBallCD();
                }
            } else if (this.getZomBossState() == ZomBossStates.FLAME || this.getZomBossState() == ZomBossStates.ICE) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimShootCD()) {
                    this.shootElementBall();
                }
            } else if (this.getZomBossState() == ZomBossStates.CAR) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimThrowCD()) {
                    this.throwDestroyCar();
                }
            } else if (this.getZomBossState() == ZomBossStates.STEAL) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimThrowCD()) {
                    this.stealRandomTargets();
                }
            }
        }
    }

    public void summonZombieByBungee() {
        if (this.getNearZombiesCount() >= this.maxZombiesInRange) {
            return;
        }
        for (int i = 0; i < this.func_70681_au().nextInt(2) + 1; ++i) {
            this.getSummonZombie().ifPresent(zombie -> {
                EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_180425_c());
                BungeeZombieEntity bungee = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                bungee.setBungeeType(BungeeZombieEntity.BungeeTypes.SUMMON);
                bungee.setBungeeState(BungeeZombieEntity.BungeeStates.DOWN);
                bungee.setStealTarget((LivingEntity)zombie);
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, (MobEntity)bungee, this.func_180425_c().func_177981_b(20), 5);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            });
        }
    }

    public void shootElementBall() {
        int now = this.getBossStage();
        float speed = now < 2 ? 0.1f : (now < 4 ? 0.2f : 0.25f);
        ElementBallEntity ball = new ElementBallEntity(this.field_70170_p, this, speed);
        ball.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
        ball.setElementBallType(this.getZomBossState() == ZomBossStates.ICE ? ElementBallEntity.ElementTypes.ICE : ElementBallEntity.ElementTypes.FLAME);
        this.field_70170_p.func_217376_c((Entity)ball);
        this.setAttackTime(0);
        this.setZomBossState(ZomBossStates.NORMAL);
    }

    public void throwDestroyCar() {
        this.setZomBossState(ZomBossStates.NORMAL);
        int plantCount = this.getNearPlantsCount();
        int throwNum = plantCount <= 40 ? 1 : (plantCount - 40 + 1) / 2 + 1;
        float range = 50.0f;
        List<LivingEntity> list = EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range));
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < throwNum; ++i) {
            int pos = this.func_70681_au().nextInt(list.size());
            DestroyCarEntity car = new DestroyCarEntity(this.field_70170_p, this);
            car.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
            car.shootPultBullet(list.get(pos));
            this.field_70170_p.func_217376_c((Entity)car);
        }
    }

    public void checkAndHeal() {
        if (this.func_70638_az() == null) {
            this.func_70691_i(10.0f);
        }
    }

    public void kickEnemiesNearby() {
        if (this.field_70173_aa % 20 == 0) {
            float range = 5.0f;
            this.field_70170_p.func_175647_a(LivingEntity.class, EntityUtil.getEntityAABB((Entity)this, range, 15.0), target -> EntityUtil.checkCanEntityAttack((Entity)target, (Entity)this)).forEach(target -> {
                if (target instanceof PVZPlantEntity) {
                    target.func_70606_j(0.0f);
                } else {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), 12.0f);
                    target.func_213317_d(target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a(2.0));
                }
            });
        }
    }

    public void stealRandomTargets() {
        this.setZomBossState(ZomBossStates.NORMAL);
        int now = this.getBossStage();
        int minCnt = 3 + now / 2;
        int maxCnt = 3 + now;
        int cnt = this.func_70681_au().nextInt(maxCnt - minCnt + 1) + minCnt;
        float range = 50.0f;
        List<LivingEntity> list = EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range));
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < cnt; ++i) {
            LivingEntity target = list.get(this.func_70681_au().nextInt(list.size()));
            BungeeZombieEntity zombie = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            zombie.setBungeeType(BungeeZombieEntity.BungeeTypes.STEAL);
            zombie.setStealTarget(target);
            zombie.setBungeeState(BungeeZombieEntity.BungeeStates.DOWN);
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_180425_c().func_177981_b(18));
        }
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ % 20 == 1 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186757_c().forEach(player -> CriteriaTriggers.field_192122_b.func_192211_a(player, (Entity)this, cause));
        }
    }

    @Override
    protected void dropCoinOrSpecial() {
        float range = 50.0f;
        int playerCnt = this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), player -> PlayerUtil.isPlayerSurvival(player)).size();
        for (int i = 0; i < 3 + 2 * playerCnt; ++i) {
            JewelEntity jewel = (JewelEntity)((EntityType)EntityRegister.JEWEL.get()).func_200721_a(this.field_70170_p);
            EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, jewel, this.func_180425_c().func_177981_b(5), 4);
        }
    }

    private Optional<PVZZombieEntity> getSummonZombie() {
        int stage = this.getBossStage();
        List<Object> summon_zombie_list = new ArrayList();
        if (stage == 1) {
            summon_zombie_list = ZOMBIES_1;
        } else if (stage == 2) {
            summon_zombie_list = ZOMBIES_2;
        } else if (stage == 3) {
            summon_zombie_list = ZOMBIES_3;
        } else if (stage == 4) {
            summon_zombie_list = ZOMBIES_4;
        } else if (stage == 5) {
            summon_zombie_list = ZOMBIES_5;
        }
        if (summon_zombie_list.isEmpty()) {
            System.out.println("Error : Wrong Boss Stage !");
            return Optional.empty();
        }
        int pos = this.func_70681_au().nextInt(summon_zombie_list.size());
        return Optional.of(ZombieUtil.getZombieEntity(this.field_70170_p, (Zombies)((Object)summon_zombie_list.get(pos))));
    }

    private int getNearPlantsCount() {
        float range = 50.0f;
        return this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), plant -> EntityUtil.checkCanEntityAttack((Entity)this, (Entity)plant)).size();
    }

    private int getNearZombiesCount() {
        float range = 30.0f;
        return this.field_70170_p.func_175647_a(PVZZombieEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), plant -> !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)plant)).size();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)9.0f);
    }

    private void resetShootBallCD() {
        int minCD = 600;
        int maxCD = 1000;
        if (this.getBossStage() > 4) {
            minCD -= 300;
            maxCD -= 400;
        } else if (this.getBossStage() > 2) {
            minCD -= 200;
            maxCD -= 200;
        }
        this.shootBallCD = this.func_70681_au().nextInt(maxCD - minCD + 1) + minCD;
    }

    private void resetStealCD() {
        int now = this.getBossStage();
        int maxCD = now <= 3 ? 800 : 600;
        int minCD = now <= 3 ? 500 : 400;
        this.stealPlantCD = this.func_70681_au().nextInt(maxCD - minCD + 1) + minCD;
    }

    public int getBossStage() {
        float percent = this.getDefenceLife() / this.getZomBossDefenceLife();
        if (percent > 0.8f) {
            return 1;
        }
        if (percent > 0.6f) {
            return 2;
        }
        if (percent > 0.4f) {
            return 3;
        }
        if (percent > 0.2f) {
            return 4;
        }
        return 5;
    }

    public float getZomBossDefenceLife() {
        return 10000.0f;
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    protected int getSummonZombieCD() {
        return 200;
    }

    public int getAnimShootCD() {
        return 40;
    }

    public int getAnimThrowCD() {
        return 30;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundRegister.ZOMBOSS_DEATH.get();
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBOSS;
    }

    @Override
    public boolean canZombieBeRemoved() {
        return false;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zomboss_state")) {
            this.setZomBossState(ZomBossStates.values()[compound.func_74762_e("zomboss_state")]);
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74764_b("zomboss_summon_tick")) {
            this.summonZombieTick = compound.func_74762_e("zomboss_summon_tick");
        }
        if (compound.func_74764_b("zomboss_shoot_ball_cd")) {
            this.shootBallCD = compound.func_74762_e("zomboss_shoot_ball_cd");
        }
        if (compound.func_74764_b("zomboss_steal_cd")) {
            this.stealPlantCD = compound.func_74762_e("zomboss_steal_cd");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zomboss_state", this.getZomBossState().ordinal());
        compound.func_74768_a("zomboss_summon_tick", this.summonZombieTick);
        compound.func_74768_a("zomboss_shoot_ball_cd", this.shootBallCD);
        compound.func_74768_a("zomboss_steal_cd", this.stealPlantCD);
    }

    public void setZomBossState(ZomBossStates state) {
        this.field_70180_af.func_187227_b(STATES, (Object)state.ordinal());
    }

    public ZomBossStates getZomBossState() {
        return ZomBossStates.values()[(Integer)this.field_70180_af.func_187225_a(STATES)];
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.ZOMBOSS;
    }

    public static enum ZomBossStates {
        NORMAL,
        FLAME,
        ICE,
        STEAL,
        CAR;

    }
}

