/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.event;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.register.EntitySpawnRegister;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Events;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.world.FogManager;
import com.hungteen.pvz.world.WaveManager;
import com.hungteen.pvz.world.data.WorldEventData;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class OverWorldEvents {
    private static final ITextComponent ZOMBIE_ATTACK = new TranslationTextComponent("event.pvz.zombie_attack", new Object[0]).func_211708_a(TextFormatting.DARK_RED);
    private static final ITextComponent ATTACK_FINISH = new TranslationTextComponent("event.pvz.attack_finish", new Object[0]).func_211708_a(TextFormatting.GREEN);

    public static void tick(TickEvent.WorldTickEvent ev) {
        World world = ev.world;
        long totalTime = world.func_72820_D();
        if (world.func_82737_E() < (long)((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.SafeDayLength.get() * 24000)) {
            return;
        }
        int dayTime = (int)(totalTime % 24000L);
        switch (dayTime) {
            case 99: {
                WorldEventData data = WorldEventData.getOverWorldEventData(world);
                data.setChanged(false);
                break;
            }
            case 100: {
                WorldEventData data = WorldEventData.getOverWorldEventData(world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                OverWorldEvents.deactivateZombieAttackEvents(world, false);
                OverWorldEvents.activateZombieAttackEvents(world);
                break;
            }
            case 23899: {
                WorldEventData data = WorldEventData.getOverWorldEventData(world);
                data.setChanged(false);
                break;
            }
            case 23900: {
                WorldEventData data = WorldEventData.getOverWorldEventData(world);
                if (data.hasChanged()) break;
                data.setChanged(true);
                OverWorldEvents.deactivateZombieAttackEvents(world, true);
                break;
            }
        }
        WaveManager.tickWave(world, dayTime);
        FogManager.tickFog(world);
    }

    public static void activateZombieAttackEvents(World world) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL && world.field_73012_v.nextInt(100) < (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.ZombieAttackChance.get()) {
            for (PlayerEntity pl : world.func_217369_A()) {
                pl.func_145747_a(ZOMBIE_ATTACK);
                PlayerUtil.playClientSound(pl, 3);
                WaveManager.resetPlayerWaveTime(pl);
            }
            Events event = EntitySpawnRegister.getCurrentEventByRandom(world);
            OverWorldEvents.activateEvent(world, event);
            if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.FogEventChance.get()) == 0) {
                OverWorldEvents.activateEvent(world, Events.FOG);
            }
            if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.MiniEventChance.get()) == 0) {
                OverWorldEvents.activateEvent(world, Events.MINI);
            }
            if (world.field_73012_v.nextInt((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.InvisEventChance.get()) == 0) {
                OverWorldEvents.activateEvent(world, Events.INVIS);
            }
            WorldEventData data = WorldEventData.getOverWorldEventData(world);
            ArrayList<Zombies> zombieList = new ArrayList<Zombies>();
            for (Zombies zombie : Zombies.values()) {
                if (!data.hasZombieSpawnEntry(zombie)) continue;
                zombieList.add(zombie);
            }
            if (((Boolean)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.ShowEventMessages.get()).booleanValue()) {
                world.func_217369_A().forEach(player -> {
                    for (Events ev : Events.values()) {
                        if (!data.hasEvent(ev)) continue;
                        player.func_145747_a(Events.getEventText(ev));
                    }
                    String zombieInfo = "";
                    for (int i = 0; i < zombieList.size(); ++i) {
                        zombieInfo = zombieInfo + new TranslationTextComponent("entity.pvz." + ((Zombies)((Object)((Object)zombieList.get(i)))).toString().toLowerCase(), new Object[0]).func_150254_d() + (i == zombieList.size() - 1 ? "" : ",");
                    }
                    player.func_145747_a((ITextComponent)new StringTextComponent(zombieInfo));
                });
            }
        }
    }

    public static void activateEvent(World world, @Nonnull Events event) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        if (!data.hasEvent(event)) {
            data.addEvent(event);
            EntitySpawnRegister.addEventSpawns(world, event);
        }
    }

    public static void deactivateZombieAttackEvents(World world, boolean isNatural) {
        boolean flag = false;
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (Object ev : Events.values()) {
            flag |= data.hasEvent((Events)((Object)ev));
        }
        if (isNatural && flag) {
            for (PlayerEntity pl : world.func_217369_A()) {
                pl.func_145747_a(ATTACK_FINISH);
                PlayerUtil.playClientSound(pl, 4);
                WaveManager.giveInvasionBonusToPlayer(world, pl);
            }
        }
        for (Object ev : Events.values()) {
            OverWorldEvents.deactivateEvent(world, ev);
        }
        EntitySpawnRegister.removeEventSpawns(world);
    }

    private static void deactivateEvent(World world, @Nonnull Events event) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        if (data.hasEvent(event)) {
            data.removeEvent(event);
        }
    }
}

