/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.event;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.gui.screen.PVZMainMenuScreen;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pvz", value={Dist.CLIENT})
public class PVZClientEvents {
    public static final BlockState ICE_BLOCK = Blocks.field_185778_de.func_176223_P();

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Pre ev) {
        MatrixStack stack = ev.getMatrixStack();
        IRenderTypeBuffer buffer = ev.getBuffers();
        int light = ev.getLight();
        PVZClientEvents.checkBungeeHandStand(ev.getEntity(), stack);
        PVZClientEvents.checkAndRenderFrozenIce(ev.getEntity(), stack, buffer, light);
        PVZClientEvents.checkAndRenderButter(ev.getRenderer(), ev.getEntity(), stack, buffer, light);
    }

    @SubscribeEvent
    public static void onGuiOpened(GuiOpenEvent event) {
        if (((Boolean)PVZConfig.CLIENT_CONFIG.OtherSettings.ShowPVZMainMenu.get()).booleanValue() && event.getGui() instanceof MainMenuScreen && !(event.getGui() instanceof PVZMainMenuScreen)) {
            event.setGui((Screen)new PVZMainMenuScreen());
        }
    }

    private static void checkBungeeHandStand(LivingEntity entity, MatrixStack stack) {
        if (entity instanceof PVZPlantEntity || entity instanceof PVZZombieEntity) {
            return;
        }
        if (entity.func_184187_bx() instanceof BungeeZombieEntity) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    private static void checkAndRenderFrozenIce(LivingEntity entity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!EntityUtil.isEntityValid((Entity)entity) || !EntityUtil.isEntityFrozen(entity)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        float scale = 0.5f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        matrixStackIn.func_227860_a_();
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(ICE_BLOCK, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(ICE_BLOCK, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(ICE_BLOCK, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(ICE_BLOCK, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    private static void checkAndRenderButter(LivingRenderer r, LivingEntity entity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!EntityUtil.isEntityValid((Entity)entity) || !EntityUtil.isEntityButter(entity)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        float scale = 0.7f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        matrixStackIn.func_227861_a_(-0.5, (double)(entity.func_213302_cg() / scale - 0.5f), -0.5);
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(((Block)BlockRegister.BUTTER_BLOCK.get()).func_176223_P(), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
    }
}

