/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen;

import com.hungteen.pvz.gui.container.CardFusionContainer;
import com.hungteen.pvz.gui.screen.AbstractOptionScreen;
import com.hungteen.pvz.gui.search.SearchCategories;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.utils.RenderUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CardFusionScreen
extends AbstractOptionScreen<CardFusionContainer> {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/card_fusion.png");
    protected Button craftButton;

    public CardFusionScreen(CardFusionContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 240;
        this.field_147000_g = 256;
    }

    @Override
    protected void init() {
        super.init();
        this.craftButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 216, this.field_147009_r + 154, 26, 18, new TranslationTextComponent("gui.pvz.fragment_splice", new Object[0]).func_150254_d(), button -> {
            if (this.craftButton.visible) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(9, 0, ((CardFusionContainer)this.field_147002_h).te.array.func_221476_a(1)));
            }
        }));
        this.craftButton.visible = false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchGui.getCurrentOption().isPresent()) {
            this.searchGui.getRecipeManager().clear();
            PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(5, 1, ((CardFusionContainer)this.field_147002_h).te.array.func_221476_a(1)));
            this.setGhostRecipe(this.searchGui.getCurrentOption().get());
            this.searchGui.resetCurrentOption();
        }
    }

    private void setGhostRecipe(SearchOption option) {
        if (option.isPlant()) {
            Plants plantType = option.getPlant().get();
            this.searchGui.getRecipeManager().setRecipe(((CardFusionContainer)this.field_147002_h).getRecipeForPlant(plantType));
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.craftButton.visible = this.canCraftNow();
        this.func_191948_b(mouseX, mouseY);
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("block.pvz.card_fusion_table", new Object[0]).func_150254_d(), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 8, 0, 1.0f);
        StringUtil.drawCenteredScaledString(this.font, "" + ((CardFusionContainer)this.field_147002_h).te.array.func_221476_a(0), this.field_147003_i + 15, this.field_147009_r + 67, 0, 0.5f);
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int maxLen = 124;
        int len = RenderUtil.getRenderBarLen(((CardFusionContainer)this.field_147002_h).te.array.func_221476_a(0), 2000, maxLen);
        this.blit(this.field_147003_i + 7, this.field_147009_r + 149 - len + 1, 240, 0, 16, len);
        RenderSystem.popMatrix();
    }

    protected boolean canCraftNow() {
        return ((CardFusionContainer)this.field_147002_h).te.array.func_221476_a(1) >= 0;
    }

    @Override
    public boolean isOptionUnLocked(SearchOption option) {
        return true;
    }

    @Override
    public List<SearchCategories> getSearchCategories() {
        return Arrays.asList(SearchCategories.FUSION);
    }
}

