/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen;

import com.hungteen.pvz.gui.container.FragmentSpliceContainer;
import com.hungteen.pvz.gui.screen.AbstractOptionScreen;
import com.hungteen.pvz.gui.search.SearchCategories;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.utils.RenderUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FragmentSpliceScreen
extends AbstractOptionScreen<FragmentSpliceContainer> {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/fragment_splice.png");
    protected Button craftButton;

    public FragmentSpliceScreen(FragmentSpliceContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 210;
        this.field_147000_g = 225;
    }

    @Override
    protected void init() {
        super.init();
        this.craftButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 92, this.field_147009_r + 122, 26, 14, new TranslationTextComponent("gui.pvz.fragment_splice", new Object[0]).func_150254_d(), button -> {
            if (this.craftButton.visible) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(5, 0, ((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(1)));
            }
        }));
        this.craftButton.visible = false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchGui.getCurrentOption().isPresent()) {
            this.searchGui.getRecipeManager().clear();
            PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(5, 1, ((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(1)));
            this.setGhostRecipe(this.searchGui.getCurrentOption().get());
            this.searchGui.resetCurrentOption();
        }
    }

    private void setGhostRecipe(SearchOption option) {
        if (option.isPlant()) {
            Plants plantType = option.getPlant().get();
            this.searchGui.getRecipeManager().setRecipe(((FragmentSpliceContainer)this.field_147002_h).getRecipeForPlant(plantType));
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.craftButton.visible = this.canCraftNow();
        this.func_191948_b(mouseX, mouseY);
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("block.pvz.fragment_splice", new Object[0]).func_150254_d(), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 8, 0, 1.0f);
        StringUtil.drawCenteredScaledString(this.font, "" + ((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(0), this.field_147003_i + 15, this.field_147009_r + 67, 0, 0.5f);
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int maxLen = 88;
        int len = RenderUtil.getRenderBarLen(((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(0), 1000, maxLen);
        this.blit(this.field_147003_i + 7, this.field_147009_r + 113 - len + 1, 210, 0, 16, len);
        RenderSystem.popMatrix();
    }

    protected boolean canCraftNow() {
        return ((FragmentSpliceContainer)this.field_147002_h).te.handler.getStackInSlot(1).func_190926_b() && ((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(0) >= 1000 && ((FragmentSpliceContainer)this.field_147002_h).te.array.func_221476_a(1) >= 0;
    }

    @Override
    public boolean isOptionUnLocked(SearchOption option) {
        return true;
    }

    @Override
    public List<SearchCategories> getSearchCategories() {
        return Arrays.asList(SearchCategories.PLANTS);
    }
}

