/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.RenderUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.GuildTopics;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class PVZGuildBookScreen
extends Screen {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/guild_book.png");
    private static final ResourceLocation TEXTURE1 = StringUtil.prefix("textures/gui/guild_book_1.png");
    private static final ResourceLocation WIDGETS = StringUtil.prefix("textures/gui/widgets.png");
    protected static final int X = 390;
    protected static final int Y = 245;
    public GuildTopics pageTopic;
    public List<Button> indexButtons = new ArrayList<Button>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int bookPagesTotal = 1;
    public int indexPages;
    public int indexPagesTotal = (int)Math.ceil((double)GuildTopics.values().length / 10.0);
    protected boolean index = true;

    public PVZGuildBookScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.pvz.guild_book", new Object[0]));
    }

    protected void init() {
        super.init();
        int centerX = (this.width - 390) / 2;
        int centerY = (this.height - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 15, centerY + 215, false, this.bookPages, button -> {
            if (this.index) {
                if (this.indexPages > 0) {
                    --this.indexPages;
                }
            } else if (this.pageTopic != null) {
                if (this.bookPages > 0) {
                    --this.bookPages;
                } else {
                    this.index = true;
                }
            }
        });
        this.addButton((Widget)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 357, centerY + 215, true, this.bookPages, button -> {
            if (this.index) {
                if (this.indexPages < this.indexPagesTotal - 1) {
                    ++this.indexPages;
                }
            } else if (this.pageTopic != null && this.bookPages < this.pageTopic.pageNum - 1) {
                ++this.bookPages;
            }
        });
        this.addButton((Widget)this.nextPage);
        for (int i = 0; i < GuildTopics.values().length; ++i) {
            int xIndex = i % -2;
            int yIndex = i % 10;
            int id = i;
            IndexPageButton button2 = new IndexPageButton(id, centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), new TranslationTextComponent("gui.pvz.guild_book" + id, new Object[0]).func_150254_d(), btn -> {
                if (this.indexButtons.get(id) != null) {
                    this.index = false;
                    this.indexPages = 0;
                    this.bookPages = 0;
                    this.pageTopic = GuildTopics.values()[id];
                }
            });
            this.indexButtons.add(button2);
            this.addButton((Widget)button2);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.buttons) {
            if (!(button instanceof IndexPageButton)) continue;
            button.active = this.index;
            button.visible = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).visible = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.width - 390) / 2;
        int cornerY = (this.height - 245) / 2;
        PVZGuildBookScreen.blit((int)cornerX, (int)cornerY, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        super.render(mouseX, mouseY, partialTicks);
        if (!this.index) {
            this.drawPerPage(this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.font.func_211126_b("" + pageLeft, (float)(cornerX + 95), (float)(cornerY + 225), 0);
            this.font.func_211126_b("" + pageRight, (float)(cornerX + 295), (float)(cornerY + 225), 0);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawPerPage(int bookPages) {
        int midX = (this.width - 390) / 2;
        int midY = (this.height - 245) / 2;
        switch (this.pageTopic) {
            case PLAYER_STATS: {
                if (this.bookPages == 0) {
                    int lvl = ClientPlayerResources.getPlayerStats(Resources.TREE_LVL);
                    int maxLvl = 100;
                    int xp = ClientPlayerResources.getPlayerStats(Resources.TREE_XP);
                    int maxXp = PlayerUtil.getPlayerLevelUpXp(lvl);
                    int sunNum = ClientPlayerResources.getPlayerStats(Resources.SUN_NUM);
                    int maxSunNum = PlayerUtil.getPlayerMaxSunNum(lvl);
                    int energyNum = ClientPlayerResources.getPlayerStats(Resources.ENERGY_NUM);
                    int maxEnergyNum = ClientPlayerResources.getPlayerStats(Resources.MAX_ENERGY_NUM);
                    int money = ClientPlayerResources.getPlayerStats(Resources.MONEY);
                    int gemNum = ClientPlayerResources.getPlayerStats(Resources.GEM_NUM);
                    RenderSystem.pushMatrix();
                    this.drawImage(TEXTURE1, midX + 15, midY + 20, 0, 96, 34, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 20, 34, 0, 126, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 20, 34, 96, RenderUtil.getRenderBarLen(lvl, maxLvl, 123), 29, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + lvl, midX + 110, midY + 27, 0xFFFFFF, 2.5f);
                    this.drawImage(TEXTURE1, midX + 15, midY + 52, 0, 128, 34, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 52, 34, 0, 126, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 52, 34, 128, RenderUtil.getRenderBarLen(xp, maxXp, 123), 29, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + xp, midX + 110, midY + 59, 0xFFFFFF, 2.5f);
                    this.drawImage(TEXTURE1, midX + 15, midY + 84, 0, 32, 34, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 84, 34, 0, 126, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 84, 34, 32, RenderUtil.getRenderBarLen(sunNum, maxSunNum, 123), 29, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + sunNum, midX + 110, midY + 91, 0xFFFFFF, 2.5f);
                    this.drawImage(TEXTURE1, midX + 15, midY + 116, 0, 64, 34, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 116, 34, 0, 126, 32, 512.0f);
                    this.drawImage(TEXTURE1, midX + 49, midY + 116, 34, 64, RenderUtil.getRenderBarLen(energyNum, maxEnergyNum, 123), 29, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + energyNum, midX + 110, midY + 123, 0xFFFFFF, 2.5f);
                    this.drawImage(TEXTURE1, midX + 15, midY + 148, 0, 160, 160, 32, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + money, midX + 110, midY + 155, 0xFFFFFF, 2.5f);
                    this.drawImage(TEXTURE1, midX + 15, midY + 180, 0, 192, 160, 32, 512.0f);
                    StringUtil.drawCenteredScaledString(this.font, "" + gemNum, midX + 110, midY + 187, 0xFFFFFF, 2.5f);
                    RenderSystem.popMatrix();
                    break;
                }
                if (this.bookPages != 1) break;
                break;
            }
            case EVENTS: {
                break;
            }
            case ESSENCES: {
                if (this.bookPages == 0) {
                    RenderSystem.pushMatrix();
                    this.drawImage(TEXTURE1, midX + 45, midY + 100, 160, 0, 16, 31, 512.0f);
                    this.drawImage(TEXTURE1, midX + 80, midY + 108, 160, 32, 25, 13, 512.0f);
                    this.drawImage(TEXTURE1, midX + 120, midY + 100, 176, 0, 16, 31, 512.0f);
                    this.drawItem(Item.func_150898_a((Block)((Block)BlockRegister.ORIGIN_ORE.get())), midX + 40, midY + 175, 1.0f);
                    this.drawItem(Items.field_151046_w, midX + 60, midY + 175, 1.0f);
                    this.drawImage(TEXTURE1, midX + 84, midY + 175, 160, 32, 25, 13, 512.0f);
                    this.drawItem((Item)ItemRegister.ORIGIN_ESSENCE.get(), midX + 115, midY + 175, 1.0f);
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            if (i == 1 && j == 1) {
                                this.drawItem(Items.field_221650_am, midX + 230 + i * 16, midY + 53 + j * 16, 1.0f);
                                continue;
                            }
                            this.drawItem((Item)ItemRegister.ORIGIN_ESSENCE.get(), midX + 230 + i * 16, midY + 53 + j * 16, 1.0f);
                        }
                    }
                    this.drawImage(TEXTURE1, midX + 280, midY + 70, 160, 32, 25, 13, 512.0f);
                    this.drawItem(Item.func_150898_a((Block)((Block)BlockRegister.ORIGIN_BLOCK.get())), midX + 310, midY + 69, 1.0f);
                    RenderSystem.popMatrix();
                    break;
                }
                if (this.bookPages == 1) {
                    RenderSystem.pushMatrix();
                    Block[] blocks = new Block[]{Blocks.field_196658_i, Blocks.field_150426_aN, Blocks.field_150451_bX, Blocks.field_196650_c, Blocks.field_205164_gk, Blocks.field_196656_g, Blocks.field_150391_bh, Blocks.field_196654_e, Blocks.field_150425_aM, Blocks.field_196814_hQ, Blocks.field_150351_n, Blocks.field_150322_A, Blocks.field_150343_Z};
                    Block[] ores = new Block[]{(Block)BlockRegister.APPEASE_ORE.get(), (Block)BlockRegister.LIGHT_ORE.get(), (Block)BlockRegister.EXPLOSION_ORE.get(), (Block)BlockRegister.DEFENCE_ORE.get(), (Block)BlockRegister.ICE_ORE.get(), (Block)BlockRegister.ENFORCE_ORE.get(), (Block)BlockRegister.TOXIC_ORE.get(), (Block)BlockRegister.ASSIST_ORE.get(), (Block)BlockRegister.MAGIC_ORE.get(), (Block)BlockRegister.FLAME_ORE.get(), (Block)BlockRegister.SPEAR_ORE.get(), (Block)BlockRegister.ARMA_ORE.get(), (Block)BlockRegister.SHADOW_ORE.get()};
                    Item[] essences = new Item[]{(Item)ItemRegister.APPEASE_ESSENCE.get(), (Item)ItemRegister.LIGHT_ESSENCE.get(), (Item)ItemRegister.EXPLOSION_ESSENCE.get(), (Item)ItemRegister.DEFENCE_ESSENCE.get(), (Item)ItemRegister.ICE_ESSENCE.get(), (Item)ItemRegister.ENFORCE_ESSENCE.get(), (Item)ItemRegister.TOXIC_ESSENCE.get(), (Item)ItemRegister.ASSIST_ESSENCE.get(), (Item)ItemRegister.MAGIC_ESSENCE.get(), (Item)ItemRegister.FLAME_ESSENCE.get(), (Item)ItemRegister.SPEAR_ESSENCE.get(), (Item)ItemRegister.ARMA_ESSENCE.get(), (Item)ItemRegister.SHADOW_ESSENCE.get()};
                    for (int i = 0; i < blocks.length; ++i) {
                        this.drawItem(Item.func_150898_a((Block)blocks[i]), midX + 40, midY + 15 + i * 16, 1.0f);
                        this.drawItem(Item.func_150898_a((Block)ores[i]), midX + 95, midY + 15 + i * 16, 1.0f);
                        this.drawItem(essences[i], midX + 145, midY + 15 + i * 16, 1.0f);
                    }
                    this.drawImage(TEXTURE1, midX + 60, midY + 125, 160, 32, 25, 13, 512.0f);
                    this.drawItem(Item.func_150898_a((Block)((Block)BlockRegister.ORIGIN_BLOCK.get())), midX + 64, midY + 100, 1.0f);
                    this.drawImage(TEXTURE1, midX + 115, midY + 125, 160, 32, 25, 13, 512.0f);
                    this.drawItem(Items.field_151046_w, midX + 119, midY + 100, 1.0f);
                    RenderSystem.popMatrix();
                    break;
                }
                if (this.bookPages != 2) break;
                RenderSystem.pushMatrix();
                RenderSystem.popMatrix();
                break;
            }
            case SUMMON_CARDS: {
                if (this.bookPages == 0) {
                    RenderSystem.pushMatrix();
                    this.drawItem((Item)ItemRegister.JALAPENO_CARD.get(), midX + 60, midY + 100, 1.0f);
                    this.drawItem((Item)ItemRegister.JALAPENO_ENJOY_CARD.get(), midX + 115, midY + 100, 1.0f);
                    RenderSystem.popMatrix();
                    break;
                }
                if (this.bookPages != 1) break;
                break;
            }
            case ZEN_GARDEN: {
                if (this.bookPages != 0) break;
                RenderSystem.pushMatrix();
                this.drawItem((Item)ItemRegister.NUT.get(), midX + 60, midY + 60, 1.0f);
                this.drawItem(Item.func_150898_a((Block)((Block)BlockRegister.CHOMPER.get())), midX + 115, midY + 60, 1.0f);
                RenderSystem.popMatrix();
                break;
            }
            case ZOMBIE_HOUSE: {
                if (this.bookPages != 0) break;
                RenderSystem.pushMatrix();
                RenderSystem.popMatrix();
                break;
            }
            case PLANT_OBTAIN: {
                if (this.bookPages == 0) {
                    RenderSystem.pushMatrix();
                    this.drawItem((Item)ItemRegister.PEA.get(), midX + 88, midY + 20, 1.0f);
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            if (i == 1 && j == 1) {
                                this.drawItem((Item)ItemRegister.ICE_ESSENCE.get(), midX + 45 + i * 16, midY + 70 + j * 16, 1.0f);
                                continue;
                            }
                            this.drawItem((Item)ItemRegister.PEA.get(), midX + 45 + i * 16, midY + 70 + j * 16, 1.0f);
                        }
                    }
                    this.drawImage(TEXTURE1, midX + 80, midY + 87, 160, 32, 25, 13, 512.0f);
                    this.drawItem((Item)ItemRegister.SNOW_PEA.get(), midX + 110, midY + 86, 1.0f);
                    this.drawItem((Item)ItemRegister.NUT.get(), midX + 285, midY + 14, 1.0f);
                    RenderSystem.popMatrix();
                    break;
                }
                if (this.bookPages != 1) break;
                RenderSystem.pushMatrix();
                this.drawItem(Item.func_150898_a((Block)((Block)BlockRegister.CHOMPER.get())), midX + 88, midY + 20, 1.0f);
                RenderSystem.popMatrix();
            }
        }
        this.writeFromTxt();
    }

    public void writeFromTxt() {
        int midX = (this.width - 390) / 2;
        int midY = (this.height - 245) / 2;
        String fileName = this.pageTopic.toString().toLowerCase() + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = StringUtil.prefix("lang/guild_book/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "/" + fileName);
        ResourceLocation backupLoc = StringUtil.prefix("lang/guild_book/zh_cn/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            int linenumber = 0;
            while (iterator.hasNext()) {
                line = ((String)iterator.next()).trim();
                if (line.contains("<") || line.contains(">")) continue;
                RenderSystem.pushMatrix();
                if (linenumber <= 19) {
                    this.font.func_211126_b(line, (float)(midX + 15), (float)(midY + 20 + linenumber * 10), 0);
                } else {
                    this.font.func_211126_b(line, (float)(midX + 210), (float)(midY + (linenumber - 19) * 10 + 3), 0);
                }
                ++linenumber;
                RenderSystem.popMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RenderSystem.pushMatrix();
        String s = new TranslationTextComponent("gui.pvz.guild_book" + this.pageTopic.ordinal(), new Object[0]).func_150254_d();
        float scale = this.font.func_78256_a(s) <= 100 ? 2.0f : (float)this.font.func_78256_a(s) * 0.0125f;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.font.func_211126_b(s, (float)(midX + 5), (float)midY, 0xFF0000);
        RenderSystem.popMatrix();
    }

    public void drawImage(ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        RenderSystem.pushMatrix();
        this.minecraft.func_110434_K().func_110577_a(texture);
        RenderSystem.scalef((float)(scale / 512.0f), (float)(scale / 512.0f), (float)(scale / 512.0f));
        PVZGuildBookScreen.blit((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)512, (int)512);
        RenderSystem.popMatrix();
    }

    private void drawItem(Item item, int x, int y, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.itemRenderer.field_77023_b = 200.0f;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.itemRenderer.field_77023_b = 5.0f;
        this.itemRenderer.func_180450_b(new ItemStack((IItemProvider)item), x, y);
        this.itemRenderer.field_77023_b = 0.0f;
        RenderSystem.scalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        RenderSystem.popMatrix();
    }

    public class ChangePageButton
    extends Button {
        private final boolean right;
        public int lastpage;
        private int page;

        public ChangePageButton(int x, int y, boolean rightButton, int bookpage, Button.IPressable press) {
            super(x, y, 23, 10, "", press);
            this.lastpage = 1;
            this.right = rightButton;
            this.page = bookpage;
        }

        public void render(int mouseX, int mouseY, float partial) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
                int i = 0;
                int j = 64;
                if (this.isHovered) {
                    i += 23;
                }
                if (!this.right) {
                    j += 13;
                }
                this.blit(this.x, this.y, i, j, this.width, this.height);
            }
        }
    }

    public class IndexPageButton
    extends Button {
        public IndexPageButton(int id, int x, int y, String buttonText, Button.IPressable butn) {
            super(x, y, 160, 32, buttonText, butn);
            this.width = 160;
            this.height = 32;
        }

        public void render(int mouseX, int mouseY, float partial) {
            if (this.visible) {
                FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS);
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                this.blit(this.x, this.y, 0, this.isHovered ? 32 : 0, this.width, this.height);
                fontrenderer.func_211126_b(this.getMessage(), (float)(this.x + this.width / 2 - fontrenderer.func_78256_a(this.getMessage()) / 2), (float)this.y + (float)((this.height - 8) / 2), this.isHovered ? 0xFF0000 : 0);
            }
        }
    }
}

