/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.gui.container.SlotMachineContainer;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.tileentity.SlotMachineTileEntity;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlotMachineScreen
extends ContainerScreen<SlotMachineContainer> {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/slot_machine.png");
    protected Button craftButton;

    public SlotMachineScreen(SlotMachineContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 176;
        this.field_147000_g = 227;
    }

    protected void init() {
        super.init();
        this.craftButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 79, this.field_147009_r + 120, 18, 18, new TranslationTextComponent("gui.pvz.slot_machine", new Object[0]).func_150254_d(), button -> {
            if (this.craftButton.visible) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(6, 0, 0));
            }
        }));
        this.craftButton.visible = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.craftButton.visible = this.canLottery();
        this.renderSlotMachine();
        this.func_191948_b(mouseX, mouseY);
    }

    private void renderSlotMachine() {
        RenderSystem.pushMatrix();
        float percent = (float)((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(12) * 1.0f / (float)((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(15);
        RenderSystem.translated((double)0.0, (double)((1.0f - percent) * 18.0f), (double)0.0);
        int currentPos = ((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(13);
        for (int i = 0; i < 4; ++i) {
            int row = (currentPos + i - 2 + 4) % 4;
            for (int j = 0; j < 3; ++j) {
                SlotMachineTileEntity.SlotOptions option = SlotMachineTileEntity.OPTION_LIST.get(((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(3 * row + j));
                int x = this.field_147003_i + 62 + 18 * j;
                int y = this.field_147009_r + 58 - 18 * i;
                if (option.plantType.isPresent()) {
                    Plants plant = option.plantType.get();
                    ItemStack stack = new ItemStack((IItemProvider)PlantUtil.getPlantEnjoyCard(plant));
                    this.itemRenderer.field_77023_b -= 100.0f;
                    this.itemRenderer.func_180450_b(stack, x, y);
                    this.itemRenderer.field_77023_b += 100.0f;
                    continue;
                }
                if (option.isJewel) {
                    RenderSystem.pushMatrix();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.minecraft.func_110434_K().func_110577_a(TEXTURE);
                    this.blit(x, y, 176, 0, 16, 16);
                    RenderSystem.popMatrix();
                    continue;
                }
                if (!option.isSun) continue;
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                this.minecraft.func_110434_K().func_110577_a(TEXTURE);
                this.blit(x, y, 176, 16, 16, 16);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translated((double)0.0, (double)0.0, (double)120.0);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i + 61, this.field_147009_r + 74, 61, 74, 54, 21);
        this.blit(this.field_147003_i + 61, this.field_147009_r + 1, 61, 1, 54, 21);
        StringUtil.drawScaledString(this.font, new TranslationTextComponent("block.pvz.slot_machine", new Object[0]).func_150254_d(), this.field_147003_i + 5, this.field_147009_r + 6, 0, 1.0f);
        StringUtil.drawScaledString(this.font, new TranslationTextComponent("gui.pvz.slot_machine.left", new Object[0]).func_150258_a(":" + ClientPlayerResources.getPlayerStats(Resources.LOTTERY_CHANCE)).func_150254_d(), this.field_147003_i + this.field_146999_f / 2 + 25, this.field_147009_r + 6, 0, 1.0f);
        StringUtil.drawScaledString(this.font, new TranslationTextComponent("gui.pvz.slot_machine.sun", new Object[0]).func_150258_a(":" + ClientPlayerResources.getPlayerStats(Resources.SUN_NUM)).func_150254_d(), this.field_147003_i + 12, this.field_147009_r + 125, 0, 0.8f);
        StringUtil.drawScaledString(this.font, new TranslationTextComponent("gui.pvz.slot_machine.cost", new Object[0]).func_150258_a(":25").func_150254_d(), this.field_147003_i + this.field_146999_f / 2 + 15, this.field_147009_r + 125, 0, 0.8f);
        RenderSystem.popMatrix();
    }

    private boolean canLottery() {
        return ClientPlayerResources.getPlayerStats(Resources.SUN_NUM) >= 25 && ClientPlayerResources.getPlayerStats(Resources.LOTTERY_CHANCE) > 0 && ((SlotMachineContainer)this.field_147002_h).te.array.func_221476_a(14) == 1;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.popMatrix();
    }
}

