/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen.shop;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.gui.container.shop.AbstractDaveShopContainer;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.TradeUtil;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractDaveShopScreen
extends ContainerScreen<AbstractDaveShopContainer> {
    public static final int TRADE_NUM_PER_PAGE = 8;
    protected final TradeButton[] trades = new TradeButton[8];
    protected List<TradeType> tradeTypes;
    protected Button buyButton;
    private int downHeight;
    protected TradeUtil.DaveGoods selectedGood;
    protected TradeType selectedTrade;

    public AbstractDaveShopScreen(AbstractDaveShopContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 285;
        this.field_147000_g = 195;
    }

    protected void init() {
        super.init();
        for (int i = 0; i < 8; ++i) {
            this.trades[i] = (TradeButton)this.addButton((Widget)new TradeButton(this.field_147003_i + 5, this.field_147009_r + 27 + 20 * i, i, button -> {
                if (button instanceof TradeButton) {
                    int id = ((TradeButton)button).getId() + this.downHeight;
                    this.selectedGood = this.getTradeTypes().get((int)id).good;
                }
            }));
        }
        this.buyButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 206, this.field_147009_r + 85, 18, 18, new TranslationTextComponent("gui.pvz.dave_shop.buy", new Object[0]).func_150254_d(), button -> {
            if (this.buyButton.visible) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(this.getShopID(), 0, this.selectedGood.ordinal()));
            }
        }));
        this.buyButton.visible = false;
        this.tradeTypes = this.getTradeTypes();
        this.selectedGood = null;
        this.selectedTrade = null;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.tradeTypes = this.getTradeTypes();
        int h = 0;
        int posX = this.field_147003_i + 6;
        int posY = this.field_147009_r + 28;
        this.renderScroll(this.tradeTypes);
        for (TradeType type : this.tradeTypes) {
            if (h >= this.downHeight && h < this.downHeight + 8) {
                this.renderTrade(type, posX, posY);
                posY += 20;
            }
            ++h;
        }
        for (TradeButton trade : this.trades) {
            if (trade.isHovered()) {
                trade.renderToolTip(mouseX, mouseY);
            }
            trade.visible = trade.id < this.tradeTypes.size();
        }
        this.selectedTrade = null;
        for (TradeType trade : this.tradeTypes) {
            if (this.selectedGood != trade.good) continue;
            this.selectedTrade = trade;
            break;
        }
        if (this.selectedTrade == null) {
            this.selectedGood = null;
        }
        this.buyButton.visible = this.canBuyNow();
        if (this.selectedGood != null && this.selectedTrade != null) {
            this.renderDetails();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void renderDetails() {
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("gui.pvz.dave_shop." + this.selectedGood.toString().toLowerCase(), new Object[0]).func_150254_d(), this.field_147003_i + 117 + 80, this.field_147009_r + 28 + 20, 0, 1.5f);
    }

    protected boolean canBuyNow() {
        return this.selectedGood != null && this.selectedTrade != null && ClientPlayerResources.getPlayerStats(Resources.MONEY) >= this.selectedTrade.money && ((AbstractDaveShopContainer)this.field_147002_h).canClickBuyButton();
    }

    protected abstract void renderTrade(TradeType var1, int var2, int var3);

    protected abstract List<TradeType> getTradeTypes();

    protected abstract int getShopID();

    protected abstract ResourceLocation getTexture();

    private void renderScroll(List<TradeType> types) {
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        int i = types.size() - 8 + 1;
        RenderSystem.pushMatrix();
        this.minecraft.func_110434_K().func_110577_a(this.getTexture());
        if (i > 1) {
            int j = 159 - (27 + (i - 1) * 159 / i);
            int k = 1 + j / i + 159 / i;
            int len = 133;
            int i1 = Math.min(len, this.downHeight * k);
            if (this.downHeight == i - 1) {
                i1 = 133;
            }
            AbstractDaveShopScreen.blit((int)(x + 106), (int)(y + 27 + i1), (int)this.getBlitOffset(), (float)0.0f, (float)195.0f, (int)6, (int)27, (int)256, (int)512);
        } else {
            AbstractDaveShopScreen.blit((int)(x + 106), (int)(y + 27), (int)this.getBlitOffset(), (float)6.0f, (float)195.0f, (int)6, (int)27, (int)256, (int)512);
        }
        RenderSystem.popMatrix();
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        int size = this.getTradeTypes().size();
        if (size > 8) {
            int next = (int)((double)this.downHeight - p_mouseScrolled_5_);
            this.downHeight = MathHelper.func_76125_a((int)next, (int)0, (int)(size - 8));
        }
        return true;
    }

    protected List<String> getToolTips(TradeType type) {
        TradeUtil.DaveGoods good = type.good;
        int num = 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= num; ++i) {
            TranslationTextComponent text = new TranslationTextComponent("gui.pvz.dave_shop." + good.toString().toLowerCase() + i, new Object[0]);
            list.add(text.func_150254_d());
        }
        return list;
    }

    public List<TradeUtil.DaveGoods> getAvailableGoods() {
        ArrayList<TradeUtil.DaveGoods> list = new ArrayList<TradeUtil.DaveGoods>();
        for (TradeUtil.DaveGoods good : TradeUtil.DaveGoods.values()) {
            if (good.shopId != this.getShopID()) continue;
            list.add(good);
        }
        return list;
    }

    public static class TradeType {
        public TradeUtil.DaveGoods good;
        public int money;
        public int exp;

        public TradeType(int money, TradeUtil.DaveGoods good) {
            this.good = good;
            this.money = money;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TradeButton
    extends Button {
        final int id;

        public TradeButton(int x, int y, int id, Button.IPressable press) {
            super(x, y, 100, 20, "", press);
            this.id = id;
            this.visible = false;
        }

        public int getId() {
            return this.id;
        }

        public void renderToolTip(int mouseX, int mouseY) {
            List<String> list = AbstractDaveShopScreen.this.getToolTips(AbstractDaveShopScreen.this.tradeTypes.get(this.id + AbstractDaveShopScreen.this.downHeight));
            AbstractDaveShopScreen.this.renderTooltip(list, mouseX, mouseY);
        }
    }
}

