/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen.shop;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.gui.container.shop.AbstractDaveShopContainer;
import com.hungteen.pvz.gui.container.shop.MysteryShopContainer;
import com.hungteen.pvz.gui.screen.shop.AbstractDaveShopScreen;
import com.hungteen.pvz.gui.screen.shop.PennyShopScreen;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.TradeUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MysteryShopScreen
extends AbstractDaveShopScreen {
    MysteryShopContainer mystery;

    public MysteryShopScreen(AbstractDaveShopContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        if (screenContainer instanceof MysteryShopContainer) {
            this.mystery = (MysteryShopContainer)screenContainer;
        }
    }

    @Override
    protected void init() {
        super.init();
        this.buyButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 206, this.field_147009_r + 85, 18, 18, new TranslationTextComponent("gui.pvz.dave_shop.buy", new Object[0]).func_150254_d(), button -> {
            if (this.buyButton.visible) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(this.getShopID(), this.selectedGood.type, this.selectedGood.ordinal()));
            }
        }));
    }

    @Override
    protected boolean canBuyNow() {
        return this.selectedGood != null && this.selectedTrade != null && ClientPlayerResources.getPlayerStats(Resources.GEM_NUM) >= this.selectedTrade.money && ((AbstractDaveShopContainer)this.field_147002_h).canClickBuyButton();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(PennyShopScreen.TEXTURE);
        MysteryShopScreen.blit((int)this.field_147003_i, (int)this.field_147009_r, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
        StringUtil.drawCenteredScaledString(this.font, ClientPlayerResources.getPlayerStats(Resources.GEM_NUM) + "", this.field_147003_i + 25 + 44, this.field_147009_r + 9, 0xFFFFFF, 1.4f);
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("gui.pvz.mystery_shop.title", new Object[0]).func_150254_d(), this.field_147003_i + 115 + 82, this.field_147009_r + 6, 0, 1.4f);
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("gui.pvz.dave_shop.time_left", new Object[0]).func_150258_a(":" + ClientPlayerResources.updateGoodTick).func_150254_d(), this.field_147003_i + 115 + 130, this.field_147009_r + 20, 0, 0.8f);
    }

    @Override
    protected void renderTrade(AbstractDaveShopScreen.TradeType trade, int posX, int posY) {
        StringUtil.drawCenteredScaledString(this.font, trade.money + "", posX + 31, posY + 4, 255, 1.2f);
        int offsetX = posX + 81;
        int offsetY = posY + 1;
        this.itemRenderer.func_175042_a(TradeUtil.getGoodItemStack(trade.good), offsetX, offsetY);
    }

    @Override
    protected void renderDetails() {
        if (this.selectedGood.toString().startsWith("ENJOY_CARD")) {
            Plants plant = Plants.values()[this.selectedGood.type];
            StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("item.pvz." + plant.toString().toLowerCase() + "_enjoy_card", new Object[0]).func_150254_d(), this.field_147003_i + 117 + 80, this.field_147009_r + 28 + 20, 0, 1.5f);
        } else {
            StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("gui.pvz.dave_shop." + this.selectedGood.toString().toLowerCase(), new Object[0]).func_150254_d(), this.field_147003_i + 117 + 80, this.field_147009_r + 28 + 20, 0, 1.5f);
        }
    }

    @Override
    public List<TradeUtil.DaveGoods> getAvailableGoods() {
        ArrayList<TradeUtil.DaveGoods> list = new ArrayList<TradeUtil.DaveGoods>();
        for (int i = 0; i < 8; ++i) {
            if (ClientPlayerResources.mysteryGoods[i] == -1) continue;
            TradeUtil.DaveGoods good = TradeUtil.DaveGoods.valueOf(TradeUtil.DaveGoods.class, "ENJOY_CARD_" + i);
            list.add(good.setType(ClientPlayerResources.mysteryGoods[i]));
        }
        return list;
    }

    @Override
    protected List<String> getToolTips(AbstractDaveShopScreen.TradeType type) {
        TradeUtil.DaveGoods good = type.good;
        int num = 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= num; ++i) {
            TranslationTextComponent text = new TranslationTextComponent("gui.pvz.dave_shop." + good.toString().toLowerCase() + i, new Object[0]);
            if (good.toString().startsWith("ENJOY_CARD")) {
                text = new TranslationTextComponent("gui.pvz.dave_shop.enjoy_card", new Object[0]);
            }
            list.add(text.func_150254_d());
        }
        return list;
    }

    @Override
    protected List<AbstractDaveShopScreen.TradeType> getTradeTypes() {
        ArrayList<AbstractDaveShopScreen.TradeType> list = new ArrayList<AbstractDaveShopScreen.TradeType>();
        this.getAvailableGoods().forEach(good -> list.add(new AbstractDaveShopScreen.TradeType(TradeUtil.getGoodCost(good), (TradeUtil.DaveGoods)((Object)good))));
        return list;
    }

    @Override
    protected ResourceLocation getTexture() {
        return PennyShopScreen.TEXTURE;
    }

    @Override
    protected int getShopID() {
        return 7;
    }
}

