/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen.shop;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.gui.container.shop.AbstractDaveShopContainer;
import com.hungteen.pvz.gui.screen.shop.AbstractDaveShopScreen;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.TradeUtil;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunShopScreen
extends AbstractDaveShopScreen {
    private static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/sun_shop.png");

    public SunShopScreen(AbstractDaveShopContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected boolean canBuyNow() {
        return this.selectedGood != null && this.selectedTrade != null && ClientPlayerResources.getPlayerStats(Resources.SUN_NUM) >= this.selectedTrade.money && ((AbstractDaveShopContainer)this.field_147002_h).canClickBuyButton();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        SunShopScreen.blit((int)this.field_147003_i, (int)this.field_147009_r, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
        StringUtil.drawCenteredScaledString(this.font, ClientPlayerResources.getPlayerStats(Resources.SUN_NUM) + "", this.field_147003_i + 25 + 44, this.field_147009_r + 9, 0xFFFFFF, 1.4f);
        StringUtil.drawCenteredScaledString(this.font, new TranslationTextComponent("gui.pvz.sun_shop.title", new Object[0]).func_150254_d(), this.field_147003_i + 115 + 82, this.field_147009_r + 6, 0, 1.4f);
    }

    @Override
    protected void renderTrade(AbstractDaveShopScreen.TradeType trade, int posX, int posY) {
        StringUtil.drawCenteredScaledString(this.font, trade.money + "", posX + 31, posY + 4, 0xFFFF00, 1.2f);
        int offsetX = posX + 81;
        int offsetY = posY + 1;
        this.itemRenderer.func_175042_a(TradeUtil.getGoodItemStack(trade.good), offsetX, offsetY);
    }

    @Override
    protected List<AbstractDaveShopScreen.TradeType> getTradeTypes() {
        ArrayList<AbstractDaveShopScreen.TradeType> list = new ArrayList<AbstractDaveShopScreen.TradeType>();
        this.getAvailableGoods().forEach(good -> list.add(new AbstractDaveShopScreen.TradeType(TradeUtil.getGoodCost(good), (TradeUtil.DaveGoods)((Object)good))));
        return list;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getShopID() {
        return 3;
    }
}

