/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.search;

import com.google.common.collect.Lists;
import com.hungteen.pvz.gui.container.AbstractOptionContainer;
import com.hungteen.pvz.gui.screen.AbstractOptionScreen;
import com.hungteen.pvz.gui.search.CategoryToggleWidget;
import com.hungteen.pvz.gui.search.OptionPage;
import com.hungteen.pvz.gui.search.RecipeManager;
import com.hungteen.pvz.gui.search.SearchCategories;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class OptionSearchGui
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    public static final ResourceLocation TEXTURE = StringUtil.prefix("textures/gui/container/almanac_search.png");
    private Minecraft mc;
    protected AbstractOptionContainer container;
    private TextFieldWidget searchBar;
    protected final RecipeManager recipeManager = new RecipeManager();
    private final List<CategoryToggleWidget> toggleTabs = Lists.newArrayList();
    private CategoryToggleWidget currentTab;
    protected OptionPage page;
    private AbstractOptionScreen<?> screen;
    private String lastSearch = "";
    private int width;
    private int height;
    private int guiLeft;
    private int guiTop;
    private final int xSize = 150;
    private final int ySize = 200;
    private boolean canType;

    public void init(Minecraft mc, AbstractOptionScreen<?> screen, AbstractOptionContainer container, int widthIn, int heightIn) {
        this.mc = mc;
        this.screen = screen;
        this.container = container;
        this.width = widthIn;
        this.height = heightIn;
        this.page = new OptionPage(screen);
        mc.field_195559_v.func_197967_a(true);
    }

    public void initSearchBar() {
        String s = this.searchBar != null ? this.searchBar.func_146179_b() : "";
        this.searchBar = new TextFieldWidget(this.mc.field_71466_p, this.guiLeft + 25, this.guiTop + 14, 100, 14, I18n.func_135052_a((String)"itemGroup.search", (Object[])new Object[0]));
        this.searchBar.func_146203_f(50);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146180_a(s);
        this.page.init(this.mc, this.guiLeft, this.guiTop);
        this.toggleTabs.clear();
        for (SearchCategories c : this.screen.getSearchCategories()) {
            this.toggleTabs.add(new CategoryToggleWidget(c));
        }
        if (this.currentTab == null) {
            this.currentTab = this.toggleTabs.get(0);
        }
        this.currentTab.func_191753_b(true);
        this.updateCollections(false);
        this.updateTabs();
    }

    public void slotClicked(@Nullable Slot slotIn) {
        if (this.container.isCraftSlot(slotIn)) {
            this.recipeManager.clear();
        }
    }

    private void updateCollections(boolean p_193003_1_) {
        List<SearchOption> list = this.page.getCurrentList(this.currentTab.getCategory());
        String s = this.searchBar.func_146179_b();
        if (!s.isEmpty()) {
            list.removeIf(a -> {
                String now = SearchOption.getOptionName(a).toLowerCase();
                return !AlgorithmUtil.KMP.kmp(now, s.toLowerCase());
            });
        }
        this.page.updateLists(list, p_193003_1_);
    }

    public void tick() {
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.canType = false;
        if (!this.mc.field_71439_g.func_175149_v()) {
            if (this.searchBar.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
                this.updateSearch();
                return true;
            }
            if (this.searchBar.isFocused()) {
                return true;
            }
            if (this.mc.field_71474_y.field_74310_D.func_197976_a(p_keyPressed_1_, p_keyPressed_2_) && !this.searchBar.isFocused()) {
                this.canType = true;
                this.searchBar.func_146195_b(true);
                return true;
            }
            return false;
        }
        return false;
    }

    private void updateSearch() {
        String s = this.searchBar.func_146179_b().toLowerCase(Locale.ROOT);
        this.pirateRecipe(s);
        if (!s.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = s;
        }
    }

    private void pirateRecipe(String text) {
        if ("excitedze".equals(text)) {
            LanguageManager languagemanager = this.mc.func_135016_M();
            Language language = languagemanager.func_191960_a("en_pt");
            if (languagemanager.func_135041_c().compareTo(language) == 0) {
                return;
            }
            languagemanager.func_135045_a(language);
            this.mc.field_71474_y.field_74363_ab = language.getCode();
            ForgeHooksClient.refreshResources((Minecraft)this.mc, (VanillaResourceType[])new VanillaResourceType[]{VanillaResourceType.LANGUAGES});
            this.mc.field_71466_p.func_78275_b(languagemanager.func_135044_b());
            this.mc.field_71474_y.func_74303_b();
        }
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.canType = false;
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.canType) {
            return false;
        }
        if (!this.mc.field_71439_g.func_175149_v()) {
            if (this.searchBar.charTyped(p_charTyped_1_, p_charTyped_2_)) {
                this.updateSearch();
                return true;
            }
            return super.charTyped(p_charTyped_1_, p_charTyped_2_);
        }
        return false;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (!this.mc.field_71439_g.func_175149_v()) {
            if (this.page.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                return true;
            }
            if (this.searchBar.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                return true;
            }
            for (CategoryToggleWidget toggle : this.toggleTabs) {
                if (!toggle.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                if (this.currentTab != toggle) {
                    this.currentTab.func_191753_b(false);
                    this.currentTab = toggle;
                    this.currentTab.func_191753_b(true);
                    this.updateCollections(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)100.0f);
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.searchBar.render(mouseX, mouseY, partialTicks);
        for (CategoryToggleWidget a : this.toggleTabs) {
            a.render(mouseX, mouseY, partialTicks);
        }
        this.page.render(this.guiLeft, this.guiTop, mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    public void renderTooltip(int guiLeft, int guiTop, int mouseX, int mouseY) {
        this.page.renderTooltip(mouseX, mouseY);
        this.renderGhostRecipeTooltip(guiLeft, guiTop, mouseX, mouseY);
    }

    private void renderGhostRecipeTooltip(int guiLeft, int guiTop, int mouseX, int mouseY) {
        ItemStack itemstack = null;
        for (int i = 0; i < this.recipeManager.size(); ++i) {
            RecipeManager.RecipeIngredient ingredient = this.recipeManager.get(i);
            int x = ingredient.getX() + guiLeft;
            int y = ingredient.getY() + guiTop;
            if (mouseX < x || mouseY < y || mouseX >= x + 16 || mouseY >= y + 16) continue;
            itemstack = ingredient.getItem();
        }
        if (itemstack != null && this.mc.field_71462_r != null) {
            this.mc.field_71462_r.renderTooltip(this.mc.field_71462_r.getTooltipFromItem(itemstack), mouseX, mouseY);
        }
    }

    public void renderGhostRecipe(int p_191864_1_, int p_191864_2_, boolean p_191864_3_, float p_191864_4_) {
        this.recipeManager.render(this.mc, p_191864_1_, p_191864_2_, p_191864_3_, p_191864_4_);
    }

    public void removed() {
        this.searchBar = null;
        this.currentTab = null;
        this.mc.field_195559_v.func_197967_a(false);
    }

    public boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)this.guiLeft || mouseY < (double)this.guiTop || mouseX >= (double)(this.guiLeft + 150) || mouseY >= (double)(this.guiTop + 200);
        return flag && !this.currentTab.isHovered();
    }

    public Optional<SearchOption> getCurrentOption() {
        return Optional.ofNullable(this.page.getCurrentOption());
    }

    public void resetCurrentOption() {
        this.page.resetCurrentOption();
    }

    public AbstractOptionScreen<?> getOptionScreen() {
        return this.screen;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    private void updateTabs() {
        int x = this.guiLeft - 30;
        int y = this.guiTop + 10;
        int h = 27;
        for (int i = 0; i < this.toggleTabs.size(); ++i) {
            CategoryToggleWidget toggle = this.toggleTabs.get(i);
            toggle.visible = true;
            toggle.func_191752_c(x, y + h * i);
        }
    }

    public int updateScreenPosition(int x, int y) {
        int totWidth = this.xSize + x;
        this.guiLeft = (this.width - totWidth) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        return this.guiLeft + this.xSize;
    }
}

