/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.item.tool;

import com.hungteen.pvz.entity.misc.bowling.AbstractBowlingEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.GroupRegister;
import com.hungteen.pvz.render.itemstack.BowlingGloveISTER;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BowlingGloveItem
extends Item {
    public static final String BOWLING_STRING = "bowling_type";

    public BowlingGloveItem() {
        super(new Item.Properties().func_200916_a(GroupRegister.PVZ_MISC).func_200917_a(1).setISTER(() -> BowlingGloveISTER::new));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        Optional<Plants> plantType = BowlingGloveItem.getBowlingType(stack);
        if (!plantType.isPresent()) {
            return ActionResultType.FAIL;
        }
        Plants plant = plantType.get();
        BlockPos spawnPos = pos;
        if (!world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            spawnPos = pos.func_177972_a(context.func_196000_l());
        }
        if (context.func_196000_l() == Direction.UP && world.func_175623_d(pos.func_177984_a())) {
            EntityType<? extends AbstractBowlingEntity> entityType = BowlingGloveItem.getEntityTypeByPlant(plant);
            if (entityType == null) {
                System.out.println("Error : no such bowling entity !");
                return ActionResultType.FAIL;
            }
            if (!world.field_72995_K) {
                AbstractBowlingEntity entity = (AbstractBowlingEntity)entityType.func_220331_a(player.field_70170_p, stack, player, spawnPos, SpawnReason.SPAWN_EGG, true, true);
                if (entity == null) {
                    System.out.println("Error : bowling entity spawn error!");
                    return ActionResultType.FAIL;
                }
                entity.setOwner((LivingEntity)player);
                entity.shoot(player);
                if (!player.field_71075_bZ.field_75098_d) {
                    BowlingGloveItem.setBowlingType(stack, Plants.PEA_SHOOTER);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static void onPickUpBowlingPlant(PVZPlantEntity plantEntity, ItemStack stack) {
        BowlingGloveItem.setBowlingType(stack, plantEntity.getPlantEnumName());
        plantEntity.func_70106_y();
    }

    private static EntityType<? extends AbstractBowlingEntity> getEntityTypeByPlant(Plants plant) {
        if (plant == Plants.WALL_NUT) {
            return (EntityType)EntityRegister.WALL_NUT_BOWLING.get();
        }
        if (plant == Plants.EXPLODE_O_NUT) {
            return (EntityType)EntityRegister.EXPLOSION_BOWLING.get();
        }
        if (plant == Plants.GIANT_WALL_NUT) {
            return (EntityType)EntityRegister.GIANT_NUT_BOWLING.get();
        }
        return null;
    }

    public static Optional<Plants> getBowlingType(ItemStack stack) {
        int type = stack.func_196082_o().func_74762_e(BOWLING_STRING);
        return BowlingGloveItem.getPlantTypeForBowling(type);
    }

    public static ItemStack setBowlingType(ItemStack stack, Plants plant) {
        stack.func_196082_o().func_74768_a(BOWLING_STRING, BowlingGloveItem.getBowlingTypeForPlants(plant));
        return stack;
    }

    public static int getBowlingTypeForPlants(Plants plant) {
        if (plant == Plants.WALL_NUT) {
            return 1;
        }
        if (plant == Plants.EXPLODE_O_NUT) {
            return 2;
        }
        if (plant == Plants.GIANT_WALL_NUT) {
            return 3;
        }
        return -1;
    }

    public static Optional<Plants> getPlantTypeForBowling(int type) {
        Plants res = null;
        if (type == 1) {
            res = Plants.WALL_NUT;
        } else if (type == 2) {
            res = Plants.EXPLODE_O_NUT;
        } else if (type == 3) {
            res = Plants.GIANT_WALL_NUT;
        }
        return Optional.ofNullable(res);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)BowlingGloveItem.setBowlingType(new ItemStack((IItemProvider)this), Plants.WALL_NUT));
            items.add((Object)BowlingGloveItem.setBowlingType(new ItemStack((IItemProvider)this), Plants.EXPLODE_O_NUT));
            items.add((Object)BowlingGloveItem.setBowlingType(new ItemStack((IItemProvider)this), Plants.GIANT_WALL_NUT));
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Optional<Plants> plant = BowlingGloveItem.getBowlingType(stack);
        if (plant.isPresent()) {
            Plants p = plant.get();
            tooltip.add(new TranslationTextComponent("tooltip.pvz.bowling_glove." + p.toString().toLowerCase(), new Object[0]).func_211708_a(TextFormatting.GOLD));
        } else {
            tooltip.add(new TranslationTextComponent("tooltip.pvz.bowling_glove.empty", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
    }
}

