/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.item.tool.card;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.block.plants.LilyPadBlock;
import com.hungteen.pvz.block.special.FlowerPotBlock;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockPlantCardItem
extends PlantCardItem {
    public BlockPlantCardItem(Plants plant, boolean isFragment) {
        super(plant, isFragment);
    }

    @Override
    public int func_77619_b() {
        return 10;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (this.plantType != Plants.LILY_PAD) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        RayTraceResult raytraceresult = BlockPlantCardItem.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
            BlockPos blockpos = blockraytraceresult.func_216350_a();
            Direction direction = blockraytraceresult.func_216354_b();
            if (!worldIn.func_175660_a(player, blockpos) || !player.func_175151_a(blockpos.func_177972_a(direction), direction, itemstack)) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            BlockPos blockpos1 = blockpos.func_177984_a();
            IFluidState ifluidstate = worldIn.func_204610_c(blockpos);
            if (ifluidstate.func_206886_c() == Fluids.field_204546_a && worldIn.func_175623_d(blockpos1)) {
                if (!worldIn.field_72995_K) {
                    PlantCardItem.checkSunAndPlaceBlock(player, this, itemstack, blockpos1);
                }
                return ActionResult.func_226248_a_((Object)itemstack);
            }
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.plantType != Plants.FLOWER_POT) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (context.func_196000_l() == Direction.UP) {
            if (world.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
                BlockPlantCardItem.checkSunAndPlaceBlock(player, this, stack, pos);
                return ActionResultType.SUCCESS;
            }
            if (world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos).func_200132_m()) {
                BlockPlantCardItem.checkSunAndPlaceBlock(player, this, stack, pos.func_177984_a());
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public static BlockState getBlockState(PlayerEntity player, Plants plant) {
        switch (plant) {
            case LILY_PAD: {
                return ((LilyPadBlock)BlockRegister.LILY_PAD.get()).getStateForPlacement(player);
            }
            case FLOWER_POT: {
                return ((FlowerPotBlock)BlockRegister.FLOWER_POT.get()).getStateForPlacement(player);
            }
        }
        PVZMod.LOGGER.debug("No such block plant!");
        return null;
    }

    public static BlockState getBlockState(Direction direction, Plants plant) {
        switch (plant) {
            case LILY_PAD: {
                return ((LilyPadBlock)BlockRegister.LILY_PAD.get()).getStateForPlacement(direction);
            }
            case FLOWER_POT: {
                return ((FlowerPotBlock)BlockRegister.FLOWER_POT.get()).getStateForPlacement(direction);
            }
        }
        PVZMod.LOGGER.debug("No such block plant!");
        return null;
    }
}

