/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.network;

import com.hungteen.pvz.gui.container.CardFusionContainer;
import com.hungteen.pvz.gui.container.EssenceAltarContainer;
import com.hungteen.pvz.gui.container.FragmentSpliceContainer;
import com.hungteen.pvz.gui.container.PlayerInventoryContainer;
import com.hungteen.pvz.gui.container.SlotMachineContainer;
import com.hungteen.pvz.gui.container.shop.DaveShopContainer;
import com.hungteen.pvz.gui.container.shop.MysteryShopContainer;
import com.hungteen.pvz.gui.container.shop.PennyShopContainer;
import com.hungteen.pvz.gui.container.shop.SunShopContainer;
import com.hungteen.pvz.utils.TradeUtil;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClickButtonPacket {
    private final int type;
    private final int op;
    private final int num;

    public ClickButtonPacket(int type, int op, int num) {
        this.type = type;
        this.op = op;
        this.num = num;
    }

    public ClickButtonPacket(PacketBuffer buffer) {
        this.type = buffer.readInt();
        this.op = buffer.readInt();
        this.num = buffer.readInt();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.op);
        buffer.writeInt(this.num);
    }

    public static class Handler {
        public static void onMessage(ClickButtonPacket message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player = ctx.get().getSender();
            ctx.get().enqueueWork(() -> {
                if (message.type == 1) {
                    if (player.field_71070_bA instanceof PlayerInventoryContainer) {
                        PlayerInventoryContainer inv = (PlayerInventoryContainer)player.field_71070_bA;
                        inv.currentPage += message.num;
                        inv.onPageChange();
                    }
                } else if (message.type == 2) {
                    if (player.field_71070_bA instanceof DaveShopContainer) {
                        DaveShopContainer container = (DaveShopContainer)player.field_71070_bA;
                        container.buyGood(TradeUtil.DaveGoods.values()[message.num]);
                    }
                } else if (message.type == 3) {
                    if (player.field_71070_bA instanceof SunShopContainer) {
                        SunShopContainer container = (SunShopContainer)player.field_71070_bA;
                        container.buyGood(TradeUtil.DaveGoods.values()[message.num]);
                    }
                } else if (message.type == 5) {
                    if (player.field_71070_bA instanceof FragmentSpliceContainer) {
                        FragmentSpliceContainer container = (FragmentSpliceContainer)player.field_71070_bA;
                        if (message.op == 0) {
                            container.te.setResult(message.num);
                        } else if (message.op == 1) {
                            container.canPutStackBackToInventory();
                        }
                    }
                } else if (message.type == 6) {
                    if (player.field_71070_bA instanceof SlotMachineContainer) {
                        SlotMachineContainer container = (SlotMachineContainer)player.field_71070_bA;
                        container.te.startRun((PlayerEntity)player);
                    }
                } else if (message.type == 4) {
                    if (player.field_71070_bA instanceof PennyShopContainer) {
                        PennyShopContainer container = (PennyShopContainer)player.field_71070_bA;
                        container.buyGood(TradeUtil.DaveGoods.values()[message.num]);
                    }
                } else if (message.type == 7) {
                    if (player.field_71070_bA instanceof MysteryShopContainer) {
                        MysteryShopContainer container = (MysteryShopContainer)player.field_71070_bA;
                        container.buyGood(TradeUtil.DaveGoods.values()[message.num], message.op);
                    }
                } else if (message.type == 8) {
                    if (player.field_71070_bA instanceof EssenceAltarContainer) {
                        EssenceAltarContainer container = (EssenceAltarContainer)player.field_71070_bA;
                        container.destroyAllCards();
                    }
                } else if (message.type == 9 && player.field_71070_bA instanceof CardFusionContainer) {
                    CardFusionContainer container = (CardFusionContainer)player.field_71070_bA;
                    if (message.op == 0) {
                        container.te.setResult(message.num);
                    } else if (message.op == 1) {
                        container.canPutStackBackToInventory();
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

