/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.register;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.biome.PVZBiome;
import com.hungteen.pvz.biome.ZenGardenBiome;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.FeatureRegister;
import com.hungteen.pvz.utils.BiomeUtil;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeRegister {
    public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "pvz");
    public static final RegistryObject<Biome> ZEN_GARDEN = BIOMES.register("zen_garden", ZenGardenBiome::new);

    public static void addBiomes() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)ZEN_GARDEN.get(), 100));
    }

    public static void addBiomeFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (biome instanceof PVZBiome) {
                ((PVZBiome)biome).addFeatures();
                ((PVZBiome)biome).addSpawns();
            }
            BiomeRegister.addStructureToBiome(biome);
        }
        for (Biome biome : BiomeUtil.PLAINS) {
            biome.func_226711_a_(((Structure)FeatureRegister.DAVE_VILLA.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        for (Biome biome : BiomeUtil.OVER_LAND) {
            biome.func_226711_a_(((Structure)FeatureRegister.BUCKET_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry((EntityType)EntityRegister.SUN.get(), 2 * (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.SunSpawnWeight.get(), 1, 1));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)EntityRegister.TOMB_STONE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.TombStoneSpawnWeight.get()).intValue(), 1, 1));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)EntityRegister.YETI_ZOMBIE.get(), 4 * (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.YetiZombieSpawnWeight.get(), 1, 1));
        }
        for (Biome biome : BiomeUtil.OCEAN) {
            biome.func_226711_a_(((Structure)FeatureRegister.DOLPHIN_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry((EntityType)EntityRegister.FOODIE_ZOMBIE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.FoodieZombieSpawnWeight.get()).intValue(), 1, 2));
        }
        for (Biome biome : BiomeUtil.NETHER) {
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)EntityRegister.LAVA_ZOMBIE.get(), ((Integer)PVZConfig.COMMON_CONFIG.WorldSettings.EntitySpawnSettings.LavaZombieSpawnWeight.get()).intValue(), 1, 1));
        }
        for (Biome biome : BiomeUtil.TAIGA) {
            biome.func_226711_a_(((Structure)FeatureRegister.GRAVE_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        for (Biome biome : BiomeUtil.DERSERT) {
            biome.func_226711_a_(((Structure)FeatureRegister.SUN_TEMPLE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        Biomes.field_76774_n.func_226711_a_(((Structure)FeatureRegister.YETI_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addStructureToBiome(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.DAVE_VILLA.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.BUCKET_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.DOLPHIN_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.GRAVE_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.SUN_TEMPLE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)FeatureRegister.YETI_HOUSE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }
}

