/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.register;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.creature.FoodieZombieEntity;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.entity.zombie.poolnight.YetiZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.BiomeUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Events;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.world.data.WorldEventData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pvz", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntitySpawnRegister {
    public static final EntitySpawnPlacementRegistry.PlacementType IN_SKY = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_in_sky", (world, pos, type) -> world.func_226660_f_(pos) && world.func_175710_j(pos.func_177982_a(0, -5, 0)));
    public static final EntitySpawnPlacementRegistry.PlacementType IN_HIGH_SKY = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_in_sky", (world, pos, type) -> world.func_226660_f_(pos) && world.func_175710_j(pos.func_177982_a(0, -20, 0)));
    public static final EntitySpawnPlacementRegistry.PlacementType ON_SNOW = EntitySpawnPlacementRegistry.PlacementType.create((String)"pvz_on_snow", (world, pos, type) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC);
    public static final EnumMap<Zombies, SpawnData> ZOMBIE_SPAWNS = new EnumMap(Zombies.class);
    public static final EnumMap<Events, Integer> EVENT_CHANCE = new EnumMap(Events.class);
    public static final List<Zombies> ZOMBIE_SPAWN_LIST = new ArrayList<Zombies>();

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> evt) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.NORMAL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FLAG_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CONEHEAD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.POLE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BUCKETHEAD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SUN.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SunEntity::canSunSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.NEWSPAPER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SCREENDOOR_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FOOTBALL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GIGA_FOOTBALL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DANCING_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BACKUP_DANCER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.OLD_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SUNDAY_EDITION_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SNORKEL_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.ZOMBONI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BOBSLE_TEAM.get()), (EntitySpawnPlacementRegistry.PlacementType)ON_SNOW, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.ZOMBIE_DOLPHIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoodieZombieEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DOLPHIN_RIDER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.FOODIE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoodieZombieEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.LAVA_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CRAZY_DAVE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.PUMPKIN_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TRICK_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.JACK_IN_BOX_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BALLOON_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BalloonZombieEntity::canBalloonSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.DIGGER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.POGO_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.YETI_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, YetiZombieEntity::canYetiSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TOMB_STONE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, TombStoneEntity::canTombSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)IN_SKY, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BalloonZombieEntity::canBalloonSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.LADDER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.CATAPULT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GARGANTUAR.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SAD_GARGANTUAR.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.PEASHOOTER_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.WALLNUT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.GATLINGPEA_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.TALLNUT_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.SQUASH_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityRegister.JALAPENO_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVZZombieEntity::canZombieSpawn);
    }

    public static void registerEntitySpawn() {
        EVENT_CHANCE.put(Events.BUCKET, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.BucketAttackChance.get());
        EVENT_CHANCE.put(Events.WATER, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.WaterAttackChance.get());
        EVENT_CHANCE.put(Events.HALLOWEEN, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.HalloweenAttackChance.get());
        EVENT_CHANCE.put(Events.NEWSPAPER, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.NewspaperAttackChance.get());
        EVENT_CHANCE.put(Events.FOOTBALL, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.FootballAttackChance.get());
        EVENT_CHANCE.put(Events.RANDOM, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.RandomAttackChance.get());
        EVENT_CHANCE.put(Events.YETI, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.YetiAttackChance.get());
        EVENT_CHANCE.put(Events.BUNGEE, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.BungeeAttackChance.get());
        EVENT_CHANCE.put(Events.METAL, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.MetalAttackChance.get());
        EVENT_CHANCE.put(Events.ROOF, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.RoofAttackChance.get());
        EVENT_CHANCE.put(Events.GIANT, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.GiantAttackChance.get());
        EVENT_CHANCE.put(Events.ZOMBOTANY, (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.EventChanceSettings.ZombotanyAttackChance.get());
        EntitySpawnRegister.putSpawnData(Zombies.NORMAL_ZOMBIE, 35, 1, 2, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.CONEHEAD_ZOMBIE, 15, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.POLE_ZOMBIE, 10, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.BUCKETHEAD_ZOMBIE, 2, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.SNORKEL_ZOMBIE, 30, 1, 2, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.ZOMBONI, 10, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.BOBSLE_TEAM, 20, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.LAVA_ZOMBIE, 3, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.PUMPKIN_ZOMBIE, 20, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.TRICK_ZOMBIE, 30, 1, 2, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.NEWSPAPER_ZOMBIE, 30, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.OLD_ZOMBIE, 15, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.SUNDAY_EDITION_ZOMBIE, 2, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.SCREENDOOR_ZOMBIE, 30, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.FOOTBALL_ZOMBIE, 12, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.DANCING_ZOMBIE, 2, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.GIGA_FOOTBALL_ZOMBIE, 2, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.JACK_IN_BOX_ZOMBIE, 15, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.BALLOON_ZOMBIE, 15, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.DIGGER_ZOMBIE, 6, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.POGO_ZOMBIE, 8, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.BUNGEE_ZOMBIE, 5, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.LADDER_ZOMBIE, 12, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.CATAPULT_ZOMBIE, 10, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.GARGANTUAR, 3, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.SAD_GARGANTUAR, 1, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.PEASHOOTER_ZOMBIE, 21, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.WALLNUT_ZOMBIE, 12, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.GATLINGPEA_ZOMBIE, 10, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.TALLNUT_ZOMBIE, 4, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.SQUASH_ZOMBIE, 8, 1, 1, BiomeUtil.OVER_LAND);
        EntitySpawnRegister.putSpawnData(Zombies.JALAPENO_ZOMBIE, 6, 1, 1, BiomeUtil.OVER_LAND);
    }

    public static List<ZombieSpawnEntry> getEventSpawnList(World world, Events ev) {
        ArrayList<ZombieSpawnEntry> list;
        block4: {
            list = new ArrayList<ZombieSpawnEntry>();
            if (!ev.isZombieAttackEvent) break block4;
            if (ev == Events.RANDOM) {
                for (Zombies zombie : EntitySpawnRegister.getRandomEventSpawnList(world)) {
                    EntitySpawnRegister.getZombieSpawnEnrty(world, zombie).ifPresent(entry -> list.add((ZombieSpawnEntry)entry));
                }
            } else {
                for (Zombies zombie : ev.zombies) {
                    EntitySpawnRegister.getZombieSpawnEnrty(world, zombie).ifPresent(entry -> list.add((ZombieSpawnEntry)entry));
                }
            }
        }
        return list;
    }

    public static List<Zombies> getRandomEventSpawnList(World world) {
        ArrayList<Zombies> zombies = new ArrayList<Zombies>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int sum = 0;
        for (Zombies zombie : ZOMBIE_SPAWN_LIST) {
            list.add(sum += zombie.chooseWeight);
        }
        for (int i = 0; i < 10 && zombies.size() < 4; ++i) {
            int now = world.field_73012_v.nextInt(sum);
            Zombies current = null;
            for (int j = 0; j < list.size(); ++j) {
                if (now >= (Integer)list.get(j)) continue;
                current = ZOMBIE_SPAWN_LIST.get(j);
                break;
            }
            if (current == null || zombies.indexOf((Object)current) != -1) continue;
            zombies.add(current);
        }
        return zombies;
    }

    public static Optional<ZombieSpawnEntry> getZombieSpawnEnrty(World world, Zombies zombie) {
        if (!ZOMBIE_SPAWNS.containsKey((Object)zombie)) {
            System.out.println("No Zombie Spawn Data");
            return Optional.empty();
        }
        int safeDuration = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.SafeDayLength.get();
        int multiple = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.MaxSpawnWeightMultiple.get();
        int length = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldEventSettings.SpawnWeightIncDuration.get();
        long day = Math.max(0L, (world.func_82737_E() - (long)safeDuration) / 24000L);
        SpawnData now = ZOMBIE_SPAWNS.get((Object)zombie);
        int min = now.weight;
        double percent = MathHelper.func_151237_a((double)(1.0 * (double)day / (double)length), (double)0.0, (double)1.0) * (double)(multiple - 1) + 1.0;
        SpawnData newData = SpawnData.setNewWeight(now, MathHelper.func_76128_c((double)(percent * (double)min)));
        return Optional.of(new ZombieSpawnEntry(zombie, newData));
    }

    public static Events getCurrentEventByRandom(World world) {
        int sum = 0;
        ArrayList<Integer> list = new ArrayList<Integer>(Events.ATTACK_EVENTS.size());
        for (Events ev : Events.ATTACK_EVENTS) {
            if (EVENT_CHANCE.containsKey((Object)ev)) {
                sum += EVENT_CHANCE.get((Object)ev).intValue();
            }
            list.add(sum);
        }
        int current = world.field_73012_v.nextInt(sum);
        Events res = null;
        for (int i = 0; i < list.size(); ++i) {
            if (current >= (Integer)list.get(i)) continue;
            res = Events.ATTACK_EVENTS.get(i);
            break;
        }
        return res;
    }

    public static void addGameEventSpawns(World world) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            EntitySpawnRegister.getZombieSpawnEnrty(world, zombie).ifPresent(entry -> entry.addWorldZombieSpawn(world));
        }
    }

    public static void removeGameEventSpawns(World world) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            EntitySpawnRegister.getZombieSpawnEnrty(world, zombie).ifPresent(entry -> entry.removeWorldZombieSpawn(world));
        }
    }

    public static void addEventSpawns(World world, Events event) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (ZombieSpawnEntry entry : EntitySpawnRegister.getEventSpawnList(world, event)) {
            Zombies zombie = entry.zombie;
            if (data.hasZombieSpawnEntry(zombie)) continue;
            data.addZombieSpawnEntry(zombie);
            entry.addWorldZombieSpawn(world);
        }
    }

    public static void removeEventSpawns(World world) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            data.removeZombieSpawnEntry(zombie);
            EntitySpawnRegister.getZombieSpawnEnrty(world, zombie).ifPresent(entry -> entry.removeWorldZombieSpawn(world));
        }
    }

    private static void putSpawnData(Zombies zombie, int weight, int minGroupSize, int maxGroupSize, Biome ... biomes) {
        ZOMBIE_SPAWNS.put(zombie, new SpawnData(weight, minGroupSize, maxGroupSize, biomes));
        ZOMBIE_SPAWN_LIST.add(zombie);
    }

    public static class SpawnData {
        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final Biome[] biomes;

        private SpawnData(int weight, int minGroupSize, int maxGroupSize, Biome ... biomes) {
            this.weight = weight;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.biomes = biomes;
        }

        public static SpawnData setNewWeight(SpawnData now, int w) {
            return new SpawnData(w, now.minGroupSize, now.maxGroupSize, now.biomes);
        }
    }

    public static class ZombieSpawnEntry {
        private final Zombies zombie;
        private final int weight;
        private final int minGroupSize;
        private final int maxGroupSize;
        private final Biome[] biomes;

        private ZombieSpawnEntry(Zombies zombie, SpawnData data) {
            this.zombie = zombie;
            this.weight = data.weight;
            this.minGroupSize = data.minGroupSize;
            this.maxGroupSize = data.maxGroupSize;
            this.biomes = data.biomes;
        }

        public void addWorldZombieSpawn(World world) {
            this.getZombieType().ifPresent(type -> {
                EntityClassification classification = type.func_220339_d();
                for (Biome biome : this.biomes) {
                    List spawns = biome.func_76747_a(classification);
                    if (spawns.stream().anyMatch(entry -> entry.field_200702_b == type)) continue;
                    spawns.add(new Biome.SpawnListEntry(type, this.weight, this.minGroupSize, this.maxGroupSize));
                }
            });
        }

        public void removeWorldZombieSpawn(World world) {
            this.getZombieType().ifPresent(type -> {
                EntityClassification classification = type.func_220339_d();
                for (Biome biome : this.biomes) {
                    biome.func_76747_a(classification).removeIf(entry -> entry.field_200702_b == type);
                }
            });
        }

        private Optional<EntityType<? extends PVZZombieEntity>> getZombieType() {
            return Optional.ofNullable(ZombieUtil.getZombieEntityType(this.zombie));
        }
    }
}

