/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.entity.plant;

import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.render.layer.PlantLadderLayer;
import com.hungteen.pvz.render.layer.PumpkinLayer;
import com.hungteen.pvz.render.layer.fullskin.CharmLayer;
import com.hungteen.pvz.render.layer.fullskin.EnergyLayer;
import com.hungteen.pvz.render.layer.fullskin.HealLightLayer;
import com.hungteen.pvz.render.layer.fullskin.SunLightLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class PVZPlantRender<T extends PVZPlantEntity>
extends MobRenderer<T, EntityModel<T>> {
    public PVZPlantRender(EntityRendererManager rendererManager, EntityModel<T> entityModelIn, float shadowSizeIn) {
        super(rendererManager, entityModelIn, shadowSizeIn);
        this.addPlantLayers();
    }

    protected void preRenderCallback(T entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float sz = this.getScaleByEntity(entitylivingbaseIn);
        Vec3d vec = this.getTranslateVec(entitylivingbaseIn);
        matrixStackIn.func_227862_a_(sz, sz, sz);
        matrixStackIn.func_227861_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected void addPlantLayers() {
        this.func_177094_a(new EnergyLayer(this));
        this.func_177094_a(new CharmLayer(this));
        this.func_177094_a(new PumpkinLayer(this));
        this.func_177094_a(new SunLightLayer(this));
        this.func_177094_a(new HealLightLayer(this));
        this.func_177094_a(new PlantLadderLayer(this));
    }

    public abstract float getScaleByEntity(T var1);

    public Vec3d getTranslateVec(T entity) {
        return new Vec3d(0.0, 0.0, 0.0);
    }
}

