/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.entity.zombie.poolnight;

import com.hungteen.pvz.entity.zombie.poolnight.DiggerZombieEntity;
import com.hungteen.pvz.model.entity.zombie.poolnight.DiggerZombieModel;
import com.hungteen.pvz.render.entity.zombie.PVZZombieRender;
import com.hungteen.pvz.utils.StringUtil;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DiggerZombieRender
extends PVZZombieRender<DiggerZombieEntity> {
    public DiggerZombieRender(EntityRendererManager rendererManager) {
        super(rendererManager, new DiggerZombieModel(), 0.3f);
    }

    @Override
    protected float getScaleByEntity(DiggerZombieEntity entity) {
        if (entity.isMiniZombie()) {
            return 0.15f;
        }
        return 0.5f;
    }

    @Override
    public Vec3d getTranslateVec(DiggerZombieEntity entity) {
        double maxOffset = 4.0;
        int now = entity.getAnimTime();
        int max = 30;
        return new Vec3d(0.0, maxOffset * (1.0 - (double)now * 1.0 / (double)max), 0.0);
    }

    public ResourceLocation getEntityTexture(DiggerZombieEntity entity) {
        return StringUtil.prefix("textures/entity/zombie/poolnight/digger_zombie.png");
    }
}

