/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.render.layer;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.model.entity.misc.LadderModel;
import com.hungteen.pvz.render.entity.plant.PVZPlantRender;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public class PlantLadderLayer<T extends PVZPlantEntity>
extends LayerRenderer<T, EntityModel<T>> {
    private static final ResourceLocation LADDER_TEX = StringUtil.prefix("textures/entity/misc/ladder.png");
    private PVZPlantRender<T> plantRender;
    private LadderModel<T> model = new LadderModel();

    public PlantLadderLayer(IEntityRenderer<T, EntityModel<T>> entityRendererIn) {
        super(entityRendererIn);
        if (entityRendererIn instanceof PVZPlantRender) {
            this.plantRender = (PVZPlantRender)entityRendererIn;
        }
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T plant, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((PVZPlantEntity)plant).hasMetal()) {
            return;
        }
        matrixStackIn.func_227860_a_();
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)LADDER_TEX));
        if (this.plantRender != null) {
            float scale = 0.6f;
            float plantScale = this.plantRender.getScaleByEntity(plant);
            matrixStackIn.func_227862_a_(scale / plantScale, scale / plantScale, scale / plantScale);
            double offsetH = 1.501;
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-22.5f));
            matrixStackIn.func_227861_a_(0.0, (double)(plantScale / scale) * offsetH - offsetH + 0.5, (double)-0.8f);
        } else {
            PVZMod.LOGGER.debug("ladder render wrong !");
        }
        this.model.render(matrixStackIn, builder, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
    }
}

