/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.tileentity;

import com.hungteen.pvz.gui.container.CardFusionContainer;
import com.hungteen.pvz.item.tool.SunStorageSaplingItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.misc.recipe.FusionRecipes;
import com.hungteen.pvz.register.TileEntityRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class CardFusionTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public final ItemStackHandler handler = new ItemStackHandler(13);
    public static final int MAX_SUN_AMOUNT = 2000;
    public static final int CRAFT_COST = 2000;
    public IIntArray array = new IntArray(2);
    public int sunAmount = 0;

    public CardFusionTileEntity() {
        super((TileEntityType)TileEntityRegister.CARD_FUSION.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.absorbSunAmount();
            this.array.func_221477_a(0, this.sunAmount);
            this.array.func_221477_a(1, this.getResultPlantId());
        }
    }

    public void setResult(int id) {
        int i;
        this.sunAmount -= 2000;
        for (i = 1; i < 9; ++i) {
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 9; i < 12; ++i) {
            this.handler.getStackInSlot(i).func_190918_g(1);
        }
        FusionRecipes recipe = FusionRecipes.values()[id];
        Plants plant = this.getFusionResult(recipe);
        this.handler.setStackInSlot(12, new ItemStack((IItemProvider)PlantUtil.getPlantSummonCard(plant)));
    }

    private Plants getFusionResult(FusionRecipes recipe) {
        int pos = this.field_145850_b.field_73012_v.nextInt(100);
        int now = 0;
        for (Pair<Plants, Integer> pair : recipe.resultPlants) {
            if (pos >= (now += ((Integer)pair.getSecond()).intValue())) continue;
            return (Plants)((Object)pair.getFirst());
        }
        pos = this.field_145850_b.field_73012_v.nextInt(recipe.requirePlants.size());
        return recipe.requirePlants.get(pos);
    }

    private int getResultPlantId() {
        if (!this.handler.getStackInSlot(12).func_190926_b() || this.sunAmount < 2000 || !this.checkEssences()) {
            return -1;
        }
        ArrayList<Plants> has = new ArrayList<Plants>();
        for (int i = 1; i < 9; ++i) {
            if (this.handler.getStackInSlot(i).func_190926_b() || !(this.handler.getStackInSlot(i).func_77973_b() instanceof PlantCardItem)) continue;
            has.add(((PlantCardItem)this.handler.getStackInSlot((int)i).func_77973_b()).plantType);
        }
        for (FusionRecipes recipe : FusionRecipes.values()) {
            if (recipe.requirePlants.size() != has.size()) continue;
            HashSet<Integer> set = new HashSet<Integer>();
            boolean match = true;
            for (Plants p : recipe.requirePlants) {
                boolean got = false;
                for (int i = 0; i < has.size(); ++i) {
                    if (p != has.get(i) || set.contains(i)) continue;
                    set.add(i);
                    got = true;
                    break;
                }
                if (got) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return recipe.ordinal();
        }
        return -1;
    }

    private boolean checkEssences() {
        for (int i = 9; i < 12; ++i) {
            if (!this.handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void absorbSunAmount() {
        ItemStack stack = this.handler.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof SunStorageSaplingItem) {
            int amount = SunStorageSaplingItem.getStorageSunAmount(stack);
            int decAmount = Math.min(2000 - this.sunAmount, Math.min(25, amount));
            this.sunAmount += decAmount;
            SunStorageSaplingItem.setStorageSunAmount(stack, amount -= decAmount);
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("itemstack_list"));
        this.sunAmount = compound.func_74762_e("sun_amount");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("itemstack_list", (INBT)this.handler.serializeNBT());
        compound.func_74768_a("sun_amount", this.sunAmount);
        return super.func_189515_b(compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new CardFusionContainer(id, player, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.pvz.card_fusion", new Object[0]);
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

