/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.HashMap;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class ZombieUtil {
    public static final float VERY_SLOW = 0.16f;
    public static final float SLOW = 0.18f;
    public static final float LITTLE_SLOW = 0.19f;
    public static final float NORMAL_SPEED = 0.2f;
    public static final float LITTLE_FAST = 0.22f;
    public static final float FAST = 0.24f;
    public static final float VERY_FAST = 0.27f;
    public static final float HUGE_FAST = 0.28f;
    public static final float SUPER_FAST = 0.3f;
    public static final float WATER_FAST = 0.8f;
    public static final float FLY_FAST = 0.5f;
    public static final float VERY_LOW = 4.0f;
    public static final float LOW = 6.0f;
    public static final float LITTLE_LOW = 8.0f;
    public static final float NORMAL_DAMAGE = 10.0f;
    public static final float LITTLE_HIGH = 20.0f;
    public static final float HIGH = 30.0f;
    public static final float VERY_HIGH = 50.0f;
    public static final float HUGE_HIGH = 100.0f;
    public static final float SUPER_HIGH = 200.0f;
    public static final float GIANT_HIT = 1000.0f;
    public static final float BOSS_HIT = 2000.0f;
    public static final float ZOMBIE_FOLLOW_RANGE = 80.0f;
    public static final HashMap<Zombies, Ranks> ZOMBIE_RANK = new HashMap();
    public static final HashMap<Zombies, RegistryObject<? extends EntityType<? extends PVZZombieEntity>>> ZOMBIE_ENTITY = new HashMap();
    public static int ZOMBIE_NUM = 0;

    public static void putZombieInfoToMap(Zombies zombie, Ranks rank, RegistryObject<? extends EntityType<? extends PVZZombieEntity>> type) {
        ZOMBIE_RANK.put(zombie, rank);
        ZOMBIE_ENTITY.put(zombie, type);
        ++ZOMBIE_NUM;
    }

    public static PVZZombieEntity getZombieEntity(World world, Zombies zombie) {
        if (ZOMBIE_ENTITY.containsKey((Object)zombie)) {
            return (PVZZombieEntity)((EntityType)ZOMBIE_ENTITY.get((Object)zombie).get()).func_200721_a(world);
        }
        PVZMod.LOGGER.debug("Zombie get entity error");
        return null;
    }

    public static EntityType<? extends PVZZombieEntity> getZombieEntityType(Zombies zombie) {
        if (ZOMBIE_ENTITY.containsKey((Object)zombie)) {
            return (EntityType)ZOMBIE_ENTITY.get((Object)zombie).get();
        }
        PVZMod.LOGGER.debug("Zombie get entity error");
        return null;
    }

    public static Ranks getZombieRank(Zombies zombie) {
        if (ZOMBIE_RANK.containsKey((Object)zombie)) {
            return ZOMBIE_RANK.get((Object)zombie);
        }
        PVZMod.LOGGER.debug("Zombie get rank error");
        return null;
    }

    public static int getZombieXp(Zombies zombie) {
        Ranks rank = ZombieUtil.getZombieRank(zombie);
        switch (rank) {
            case GRAY: {
                return 1;
            }
            case WHITE: {
                return 2;
            }
            case GREEN: {
                return 3;
            }
            case BLUE: {
                return 5;
            }
            case PURPLE: {
                return 8;
            }
            case GOLD: {
                return 15;
            }
            case MEGA: {
                return 50;
            }
        }
        return 0;
    }

    static {
        ZombieUtil.putZombieInfoToMap(Zombies.NORMAL_ZOMBIE, Ranks.WHITE, EntityRegister.NORMAL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.FLAG_ZOMBIE, Ranks.WHITE, EntityRegister.FLAG_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.CONEHEAD_ZOMBIE, Ranks.GREEN, EntityRegister.CONEHEAD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.POLE_ZOMBIE, Ranks.GREEN, EntityRegister.POLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BUCKETHEAD_ZOMBIE, Ranks.BLUE, EntityRegister.BUCKETHEAD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.NEWSPAPER_ZOMBIE, Ranks.WHITE, EntityRegister.NEWSPAPER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TOMB_STONE, Ranks.GRAY, EntityRegister.TOMB_STONE);
        ZombieUtil.putZombieInfoToMap(Zombies.SCREENDOOR_ZOMBIE, Ranks.WHITE, EntityRegister.SCREENDOOR_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.FOOTBALL_ZOMBIE, Ranks.BLUE, EntityRegister.FOOTBALL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DANCING_ZOMBIE, Ranks.GREEN, EntityRegister.DANCING_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BACKUP_DANCER, Ranks.WHITE, EntityRegister.BACKUP_DANCER);
        ZombieUtil.putZombieInfoToMap(Zombies.GIGA_FOOTBALL_ZOMBIE, Ranks.GOLD, EntityRegister.GIGA_FOOTBALL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.OLD_ZOMBIE, Ranks.BLUE, EntityRegister.OLD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SUNDAY_EDITION_ZOMBIE, Ranks.GOLD, EntityRegister.SUNDAY_EDITION_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.COFFIN, Ranks.GOLD, EntityRegister.COFFIN);
        ZombieUtil.putZombieInfoToMap(Zombies.MOURNER_ZOMBIE, Ranks.GREEN, EntityRegister.MOURNER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.NOBLE_ZOMBIE, Ranks.MEGA, EntityRegister.NOBLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SNORKEL_ZOMBIE, Ranks.WHITE, EntityRegister.SNORKEL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBONI, Ranks.BLUE, EntityRegister.ZOMBONI);
        ZombieUtil.putZombieInfoToMap(Zombies.BOBSLE_TEAM, Ranks.GREEN, EntityRegister.BOBSLE_TEAM);
        ZombieUtil.putZombieInfoToMap(Zombies.BOBSLE_ZOMBIE, Ranks.WHITE, EntityRegister.BOBSLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DOLPHIN_RIDER, Ranks.GREEN, EntityRegister.DOLPHIN_RIDER);
        ZombieUtil.putZombieInfoToMap(Zombies.DOLPHIN_RIDER_ZOMBIE, Ranks.WHITE, EntityRegister.DOLPHIN_RIDER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBIE_DOLPHIN, Ranks.GRAY, EntityRegister.ZOMBIE_DOLPHIN);
        ZombieUtil.putZombieInfoToMap(Zombies.LAVA_ZOMBIE, Ranks.PURPLE, EntityRegister.LAVA_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.JACK_IN_BOX_ZOMBIE, Ranks.GREEN, EntityRegister.JACK_IN_BOX_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BALLOON_ZOMBIE, Ranks.WHITE, EntityRegister.BALLOON_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DIGGER_ZOMBIE, Ranks.GREEN, EntityRegister.DIGGER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.POGO_ZOMBIE, Ranks.GREEN, EntityRegister.POGO_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.YETI_ZOMBIE, Ranks.BLUE, EntityRegister.YETI_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BUNGEE_ZOMBIE, Ranks.GREEN, EntityRegister.BUNGEE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.LADDER_ZOMBIE, Ranks.GREEN, EntityRegister.LADDER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.CATAPULT_ZOMBIE, Ranks.BLUE, EntityRegister.CATAPULT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.GARGANTUAR, Ranks.PURPLE, EntityRegister.GARGANTUAR);
        ZombieUtil.putZombieInfoToMap(Zombies.IMP, Ranks.GRAY, EntityRegister.IMP);
        ZombieUtil.putZombieInfoToMap(Zombies.SAD_GARGANTUAR, Ranks.GOLD, EntityRegister.SAD_GARGANTUAR);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBOSS, Ranks.MEGA, EntityRegister.ZOMBOSS);
        ZombieUtil.putZombieInfoToMap(Zombies.PEASHOOTER_ZOMBIE, Ranks.WHITE, EntityRegister.PEASHOOTER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.WALLNUT_ZOMBIE, Ranks.BLUE, EntityRegister.WALLNUT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.GATLINGPEA_ZOMBIE, Ranks.WHITE, EntityRegister.GATLINGPEA_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TALLNUT_ZOMBIE, Ranks.PURPLE, EntityRegister.TALLNUT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SQUASH_ZOMBIE, Ranks.WHITE, EntityRegister.SQUASH_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.JALAPENO_ZOMBIE, Ranks.GREEN, EntityRegister.JALAPENO_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.PUMPKIN_ZOMBIE, Ranks.PURPLE, EntityRegister.PUMPKIN_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TRICK_ZOMBIE, Ranks.GRAY, EntityRegister.TRICK_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.RA_ZOMBIE, Ranks.WHITE, EntityRegister.RA_ZOMBIE);
    }
}

