/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils.enums;

import com.hungteen.pvz.utils.enums.Bundles;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum Events {
    BUCKET(true, Bundles.GRASS_DAY, Zombies.NORMAL_ZOMBIE, Zombies.CONEHEAD_ZOMBIE, Zombies.POLE_ZOMBIE, Zombies.BUCKETHEAD_ZOMBIE),
    WATER(true, Bundles.POOL_DAY, Zombies.NORMAL_ZOMBIE, Zombies.SNORKEL_ZOMBIE, Zombies.ZOMBONI, Zombies.BOBSLE_TEAM, Zombies.LAVA_ZOMBIE),
    HALLOWEEN(true, Bundles.RANDOM, Zombies.NORMAL_ZOMBIE, Zombies.TRICK_ZOMBIE, Zombies.PUMPKIN_ZOMBIE),
    NEWSPAPER(true, Bundles.GRASS_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.NEWSPAPER_ZOMBIE, Zombies.OLD_ZOMBIE, Zombies.SUNDAY_EDITION_ZOMBIE),
    FOOTBALL(true, Bundles.GRASS_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.DANCING_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE),
    RANDOM(true, Bundles.RANDOM, new Zombies[0]),
    FOG(false),
    YETI(true, Bundles.POOL_NIGHT, Zombies.NORMAL_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.BALLOON_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.POGO_ZOMBIE),
    BUNGEE(true, Bundles.ROOF, Zombies.BUNGEE_ZOMBIE),
    METAL(true, Bundles.UPGRADE, Zombies.BUCKETHEAD_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.POGO_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.LADDER_ZOMBIE),
    ROOF(true, Bundles.ROOF, Zombies.NORMAL_ZOMBIE, Zombies.BUNGEE_ZOMBIE, Zombies.LADDER_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR),
    GIANT(true, Bundles.UPGRADE, Zombies.GARGANTUAR, Zombies.SAD_GARGANTUAR),
    MINI(false),
    INVIS(false),
    ZOMBOTANY(true, Bundles.RANDOM, Zombies.PEASHOOTER_ZOMBIE, Zombies.WALLNUT_ZOMBIE, Zombies.GATLINGPEA_ZOMBIE, Zombies.TALLNUT_ZOMBIE, Zombies.SQUASH_ZOMBIE, Zombies.JALAPENO_ZOMBIE);

    public static final List<Events> ATTACK_EVENTS;
    public boolean isZombieAttackEvent;
    public final List<Zombies> zombies;
    public Optional<Bundles> bundle = Optional.empty();

    public static ITextComponent getEventText(Events ev) {
        TranslationTextComponent text = new TranslationTextComponent("event.pvz." + ev.toString().toLowerCase(), new Object[0]);
        switch (ev) {
            case BUCKET: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.GRAY});
                break;
            }
            case WATER: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_BLUE});
                break;
            }
            case HALLOWEEN: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.GOLD});
                break;
            }
            case NEWSPAPER: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_GRAY});
                break;
            }
            case FOOTBALL: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.BLACK});
                break;
            }
            case YETI: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.AQUA});
                break;
            }
            case FOG: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.GRAY});
                break;
            }
            case RANDOM: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.GREEN});
                break;
            }
            case BUNGEE: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.RED});
                break;
            }
            case METAL: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.BLACK});
                break;
            }
            case ROOF: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.GOLD});
                break;
            }
            case GIANT: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_RED});
                break;
            }
            case MINI: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_AQUA});
                break;
            }
            case INVIS: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_GRAY});
                break;
            }
            case ZOMBOTANY: {
                text.func_211709_a(new TextFormatting[]{TextFormatting.DARK_GREEN});
                break;
            }
        }
        return text;
    }

    private Events(boolean isAttackEvent) {
        this.zombies = new ArrayList<Zombies>();
    }

    private Events(boolean isAttackEvent, Bundles bundle, Zombies ... zombies) {
        this.isZombieAttackEvent = isAttackEvent;
        this.bundle = Optional.of(bundle);
        this.zombies = Arrays.asList(zombies);
    }

    static {
        ATTACK_EVENTS = new ArrayList<Events>();
        for (Events ev : Events.values()) {
            if (!ev.isZombieAttackEvent) continue;
            ATTACK_EVENTS.add(ev);
        }
    }
}

