/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.world;

import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.capability.player.PlayerDataManager;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.network.OtherStatsPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Events;
import com.hungteen.pvz.utils.enums.Resources;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.world.data.WorldEventData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.PacketDistributor;

public class WaveManager {
    private static final ITextComponent HUGE_WAVE = new TranslationTextComponent("event.pvz.huge_wave", new Object[0]).func_211708_a(TextFormatting.DARK_RED);
    public static final int MAX_WAVE_NUM = 5;
    public static final int FINISH_OFFSET = 30000;
    private final World world;
    private final int currentWave;
    private final PlayerEntity player;
    private final BlockPos center;
    private final List<Zombies> spawns = new ArrayList<Zombies>();
    private final List<Integer> spawnWeights = new ArrayList<Integer>();
    private final int[] minSpawnCounts = new int[]{8, 12, 16, 21, 28};
    private final int[] maxSpawnCounts = new int[]{15, 20, 25, 32, 40};
    public int spawnCnt = 0;

    public WaveManager(PlayerEntity player, int waveNum) {
        this.world = player.field_70170_p;
        this.currentWave = waveNum;
        this.player = player;
        this.center = player.func_180425_c();
        this.updateSpawns();
    }

    public static void tickWave(World world, int dayTime) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return;
        }
        world.func_217369_A().forEach(player -> {
            if (PlayerUtil.isPlayerSurvival(player)) {
                player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                    PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
                    for (int i = 0; i < stats.zombieWaveTime.length; ++i) {
                        int time = stats.zombieWaveTime[i];
                        if (time == 0 || time != dayTime) continue;
                        WaveManager manager = new WaveManager((PlayerEntity)player, i);
                        manager.spawnWaveZombies();
                        int n = i;
                        stats.zombieWaveTime[n] = stats.zombieWaveTime[n] + 30000;
                        WaveManager.syncWaveTime(player);
                        break;
                    }
                });
            }
        });
    }

    public static void syncWaveTime(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
            for (int i = 0; i < 5; ++i) {
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(1, i, stats.zombieWaveTime[i]));
            }
            PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OtherStatsPacket(1, -1, stats.totalWaveCount));
        });
    }

    public void activateTombStone() {
        if (this.world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return;
        }
        int len = 30;
        this.world.func_175647_a(TombStoneEntity.class, EntityUtil.getEntityAABB((Entity)this.player, len, len), tombstone -> true).forEach(tomb -> tomb.summonZombie());
    }

    public void spawnWaveZombies() {
        int cnt;
        int teamCnt;
        if (this.world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return;
        }
        int now = 0;
        for (int i = 0; i < this.spawns.size(); ++i) {
            Zombies zombie = this.spawns.get(i);
            this.spawnWeights.add(now += zombie.spawnWeight);
        }
        if (now == 0) {
            return;
        }
        boolean spawned = false;
        int groupNum = 0;
        for (cnt = this.getSpawnCount(); cnt >= 10; cnt -= teamCnt) {
            teamCnt = cnt < 15 ? cnt : 10;
            spawned |= this.spawnZombieTeam(++groupNum, now, teamCnt);
        }
        if (cnt > 0) {
            spawned |= this.spawnZombieTeam(++groupNum, now, cnt);
        }
        if (spawned) {
            PlayerUtil.playClientSound(this.player, 2);
            PlayerUtil.sendSubTitleToPlayer(this.player, HUGE_WAVE);
            this.activateTombStone();
            this.checkAndSummonBungee();
        }
    }

    protected void checkAndSummonBungee() {
        WorldEventData data = WorldEventData.getOverWorldEventData(this.world);
        if (!data.hasZombieSpawnEntry(Zombies.BUNGEE_ZOMBIE)) {
            return;
        }
        int minCnt = 5 + this.currentWave;
        int maxCnt = 5 + 3 * this.currentWave;
        int cnt = this.world.field_73012_v.nextInt(maxCnt - minCnt + 1) + minCnt;
        int height = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.player.func_180425_c().func_177958_n(), this.player.func_180425_c().func_177952_p());
        for (int i = 0; i < cnt; ++i) {
            int posX = this.world.field_73012_v.nextInt(71) - 35;
            int posZ = this.world.field_73012_v.nextInt(71) - 35;
            BungeeZombieEntity bungee = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.world);
            bungee.setBungeeType(BungeeZombieEntity.BungeeTypes.SUMMON);
            EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)bungee, new BlockPos(this.player.func_180425_c().func_177958_n() + posX, height + 20, this.player.func_180425_c().func_177952_p() + posZ));
            EntityUtil.playSound((Entity)this.player, (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
        }
    }

    public static void resetPlayerWaveTime(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            PlayerDataManager.OtherStats stats = l.getPlayerData().getOtherStats();
            int treeLvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
            int maxCnt = PlayerUtil.getPlayerWaveCount(treeLvl);
            int minCnt = (maxCnt + 1) / 2;
            int cnt = player.func_70681_au().nextInt(maxCnt - minCnt + 1) + minCnt;
            int partTime = 24000 / cnt;
            for (int i = 0; i < 5; ++i) {
                if (i < cnt) {
                    int time = player.func_70681_au().nextInt(partTime - 2000);
                    stats.zombieWaveTime[i] = time + i * partTime + 1000;
                    continue;
                }
                stats.zombieWaveTime[i] = 0;
            }
            stats.totalWaveCount = cnt;
            WaveManager.syncWaveTime(player);
        });
    }

    public static void giveInvasionBonusToPlayer(World world, PlayerEntity player) {
        if (!PlayerUtil.isPlayerSurvival(player)) {
            return;
        }
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int cnt = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.KILL_COUNT);
            if (cnt >= 20) {
                PlayerUtil.playClientSound(player, 6);
                PlayerUtil.addPlayerStats(player, Resources.MONEY, 50);
                PlayerUtil.addPlayerStats(player, Resources.LOTTERY_CHANCE, 2);
                player.func_191521_c(WaveManager.getRandomItemForPlayer(world));
            }
            l.getPlayerData().getPlayerStats().setPlayerStats(Resources.KILL_COUNT, 0);
        });
    }

    private static ItemStack getRandomItemForPlayer(World world) {
        WorldEventData data = WorldEventData.getOverWorldEventData(world);
        for (Events ev : Events.values()) {
            if (!data.hasEvent(ev) || !ev.bundle.isPresent()) continue;
            return ev.bundle.get().getRandomBundle();
        }
        return ItemStack.field_190927_a;
    }

    private boolean spawnZombieTeam(int groupNum, int sum, int cnt) {
        WorldEventData data;
        BlockPos mid = this.findRandomSpawnPos(20);
        if (mid == null) {
            return false;
        }
        block0: for (int i = 0; i < cnt; ++i) {
            int tmp = this.world.field_73012_v.nextInt(sum);
            for (int j = 0; j < this.spawnWeights.size(); ++j) {
                if (tmp >= this.spawnWeights.get(j)) continue;
                this.spawnZombie(this.spawns.get(j), mid);
                continue block0;
            }
        }
        if (groupNum == 1 && (data = WorldEventData.getOverWorldEventData(this.world)).hasEvent(Events.YETI) && this.world.field_73012_v.nextInt(3) == 0) {
            PVZZombieEntity yeti = (PVZZombieEntity)((EntityType)EntityRegister.YETI_ZOMBIE.get()).func_200721_a(this.world);
            EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)yeti, mid.func_177982_a(0, 1, 0));
        }
        PVZZombieEntity flagZombie = (PVZZombieEntity)((EntityType)EntityRegister.FLAG_ZOMBIE.get()).func_200721_a(this.world);
        EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)flagZombie, mid.func_177982_a(0, 1, 0));
        return true;
    }

    private void spawnZombie(Zombies zombie, BlockPos pos) {
        int range = 11;
        int x = pos.func_177958_n() + this.world.field_73012_v.nextInt(range) - range / 2;
        int z = pos.func_177952_p() + this.world.field_73012_v.nextInt(range) - range / 2;
        int y = this.world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
        PVZZombieEntity zombieEntity = ZombieUtil.getZombieEntity(this.world, zombie);
        EntityUtil.onMobEntitySpawn((IWorld)this.world, (MobEntity)zombieEntity, new BlockPos(x, y + 1, z));
    }

    private int getSpawnCount() {
        if (this.spawnCnt != 0) {
            return this.spawnCnt;
        }
        int minCnt = this.minSpawnCounts[this.currentWave];
        int maxCnt = this.maxSpawnCounts[this.currentWave];
        return this.world.field_73012_v.nextInt(maxCnt - minCnt + 1) + minCnt;
    }

    private void updateSpawns() {
        WorldEventData data = WorldEventData.getOverWorldEventData(this.world);
        for (Zombies zombie : Zombies.values()) {
            if (!data.hasZombieSpawnEntry(zombie)) continue;
            this.spawns.add(zombie);
        }
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int chance) {
        int range = 16;
        int distance = 48;
        for (int i = 0; i < chance; ++i) {
            int z;
            int y;
            float f = this.world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            int dx = MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)f) * (float)distance));
            int dz = MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)f) * (float)distance));
            int x = this.center.func_177958_n() + (dx > 0 ? dx + range : dx - range);
            BlockPos pos = new BlockPos(x, y = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = this.center.func_177952_p() + (dz > 0 ? dz + range : dz - range)), z);
            if (!this.world.func_175707_a(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range, range, range)) || !this.world.func_72863_F().func_222865_a(new ChunkPos(pos)) || !this.world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206888_e() || this.world.func_226658_a_(LightType.BLOCK, pos) >= 7) continue;
            return pos;
        }
        return null;
    }
}

