/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.world.data;

import com.hungteen.pvz.utils.enums.Events;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class WorldEventData
extends WorldSavedData {
    private static final String DATA_NAME = "WorldEventData";
    private HashSet<Events> events = new HashSet(Events.values().length);
    private HashSet<Zombies> zombies = new HashSet(Zombies.values().length);
    private boolean changed = false;
    private boolean isZomBossDefeated = false;
    private boolean mustStartNextDay = false;
    private boolean mustNotStartNextDay = false;

    public WorldEventData() {
        super(DATA_NAME);
    }

    public WorldEventData(String name) {
        super(name);
    }

    public boolean hasZombieSpawnEntry(Zombies zombie) {
        return this.zombies.contains((Object)zombie);
    }

    public void addZombieSpawnEntry(Zombies zombie) {
        this.zombies.add(zombie);
        this.func_76185_a();
    }

    public void removeZombieSpawnEntry(Zombies zombie) {
        this.zombies.remove((Object)zombie);
        this.func_76185_a();
    }

    public boolean hasEvent(Events ev) {
        return this.events.contains((Object)ev);
    }

    public void addEvent(Events ev) {
        this.events.add(ev);
        this.func_76185_a();
    }

    public void removeEvent(Events ev) {
        this.events.remove((Object)ev);
        this.func_76185_a();
    }

    public void setChanged(boolean is) {
        this.changed = is;
        this.func_76185_a();
    }

    public void setIsZomBossDefeated(boolean is) {
        this.isZomBossDefeated = is;
        this.func_76185_a();
    }

    public void setMustStartNextDay(boolean is) {
        this.mustStartNextDay = is;
        this.func_76185_a();
    }

    public void setMustNotStartNextDay(boolean is) {
        this.mustNotStartNextDay = is;
        this.func_76185_a();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean getIsZomBossDefeated() {
        return this.isZomBossDefeated;
    }

    public boolean getMustStartNextDay() {
        return this.mustStartNextDay;
    }

    public boolean getMustNotStartNextDay() {
        return this.mustNotStartNextDay;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.events.clear();
        ListNBT list = (ListNBT)nbt.func_74781_a("event");
        if (list != null) {
            for (INBT tmp : list) {
                CompoundNBT tag = (CompoundNBT)tmp;
                this.events.add(Events.values()[tag.func_74762_e("id")]);
            }
        }
        this.zombies.clear();
        if (nbt.func_74764_b("zombie_spawn_entries")) {
            CompoundNBT list2 = nbt.func_74775_l("zombie_spawn_entries");
            for (Zombies zombie : Zombies.values()) {
                if (!list2.func_74764_b("type_" + zombie.toString()) || !list2.func_74767_n("type_" + zombie.toString())) continue;
                this.addZombieSpawnEntry(zombie);
            }
        }
        this.changed = nbt.func_74767_n("changed");
        this.isZomBossDefeated = nbt.func_74767_n("is_zomboss_defeated");
        this.mustStartNextDay = nbt.func_74767_n("must_start_next_day");
        this.mustNotStartNextDay = nbt.func_74767_n("must_not_start_next_day");
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.events.stream().forEach(event -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("id", event.ordinal());
            list.add((Object)tag);
        });
        nbt.func_218657_a("event", (INBT)list);
        CompoundNBT list2 = new CompoundNBT();
        for (Zombies zombie : Zombies.values()) {
            list2.func_74757_a("type_" + zombie.toString(), this.hasZombieSpawnEntry(zombie));
        }
        nbt.func_218657_a("zombie_spawn_entries", (INBT)list2);
        nbt.func_74757_a("changed", this.changed);
        nbt.func_74757_a("is_zomboss_defeated", this.isZomBossDefeated);
        nbt.func_74757_a("must_start_next_day", this.mustStartNextDay);
        nbt.func_74757_a("must_not_start_next_day", this.mustNotStartNextDay);
        return nbt;
    }

    public static WorldEventData getOverWorldEventData(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld world = worldIn.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
        DimensionSavedDataManager storage = world.func_217481_x();
        return (WorldEventData)storage.func_215752_a(WorldEventData::new, DATA_NAME);
    }
}

