/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.AngleArgument;
import exopandora.worldhandler.builder.argument.BlockPosArgument;
import exopandora.worldhandler.builder.argument.BlockPredicateArgument;
import exopandora.worldhandler.builder.argument.BlockStateArgument;
import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.argument.EffectArgument;
import exopandora.worldhandler.builder.argument.EnchantmentArgument;
import exopandora.worldhandler.builder.argument.EntitySummonArgument;
import exopandora.worldhandler.builder.argument.Gamemode;
import exopandora.worldhandler.builder.argument.ItemArgument;
import exopandora.worldhandler.builder.argument.ItemPredicateArgument;
import exopandora.worldhandler.builder.argument.NbtPathArgument;
import exopandora.worldhandler.builder.argument.PrimitiveArgument;
import exopandora.worldhandler.builder.argument.RangeArgument;
import exopandora.worldhandler.builder.argument.TagArgument;
import exopandora.worldhandler.builder.argument.TargetArgument;
import exopandora.worldhandler.builder.argument.TimeArgument;
import exopandora.worldhandler.util.EnumHelper;
import java.util.function.Function;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class Arguments {
    public static PrimitiveArgument<Short> shortArg() {
        return new PrimitiveArgument.Builder<Short>(string -> {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Byte> byteArg() {
        return new PrimitiveArgument.Builder<Byte>(string -> {
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Integer> intArg() {
        return new PrimitiveArgument.Builder<Integer>(string -> {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Float> floatArg() {
        return new PrimitiveArgument.Builder<Float>(string -> {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Double> doubleArg() {
        return new PrimitiveArgument.Builder<Double>(string -> {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Long> longArg() {
        return new PrimitiveArgument.Builder<Long>(string -> {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<Boolean> boolArg() {
        return new PrimitiveArgument.Builder<Boolean>(string -> {
            try {
                return Boolean.parseBoolean(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).build();
    }

    public static PrimitiveArgument<String> string() {
        return new PrimitiveArgument.Builder<String>(Function.identity()).serializer(string -> string.isBlank() ? null : StringArgumentType.escapeIfRequired((String)string)).build();
    }

    public static PrimitiveArgument<String> greedyString() {
        return new PrimitiveArgument.Builder<String>(string -> string == null || string.isBlank() ? null : string).serializer(string -> string.isBlank() ? null : string).defaultOverride(string -> string == null || string.isBlank()).build();
    }

    public static PrimitiveArgument<String> word() {
        return new PrimitiveArgument.Builder<String>(string -> string == null || string.isBlank() ? null : string).serializer(string -> string.isBlank() ? null : string.replaceAll("[^0-9A-Za-z_\\-.+]", "_")).defaultOverride(string -> string == null || string.isBlank()).build();
    }

    public static PrimitiveArgument<ResourceLocation> resourceLocation() {
        return new PrimitiveArgument.Builder<ResourceLocation>(string -> string.isEmpty() ? null : new ResourceLocation(string)).build();
    }

    public static ItemArgument item() {
        return new ItemArgument();
    }

    public static BlockStateArgument blockState() {
        return new BlockStateArgument();
    }

    public static BlockPredicateArgument blockPredicate() {
        return new BlockPredicateArgument();
    }

    public static TagArgument tag() {
        return new TagArgument();
    }

    public static PrimitiveArgument<Coordinate<Integer>> intCoordinate() {
        return new PrimitiveArgument.Builder<Coordinate>(Coordinate.Ints::parse).build();
    }

    public static PrimitiveArgument<Coordinate<Double>> doubleCoordinate() {
        return new PrimitiveArgument.Builder<Coordinate>(Coordinate.Doubles::parse).build();
    }

    public static RangeArgument<Integer> intRange() {
        return new RangeArgument<Integer>(string -> {
            try {
                return MinMaxBounds.Ints.m_55375_((StringReader)new StringReader(string));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    public static RangeArgument<Double> doubleRange() {
        return new RangeArgument<Double>(string -> {
            try {
                return MinMaxBounds.Doubles.m_154793_((StringReader)new StringReader(string));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    public static AngleArgument angle() {
        return new AngleArgument();
    }

    public static EnchantmentArgument enchantment() {
        return new EnchantmentArgument();
    }

    public static EntitySummonArgument entitySummon() {
        return new EntitySummonArgument();
    }

    public static PrimitiveArgument<Gamemode> gamemode() {
        return new PrimitiveArgument.Builder<Gamemode>(string -> (Gamemode)EnumHelper.find((String)string, (Enum[])Gamemode.values(), Gamemode::toString)).build();
    }

    public static TimeArgument time() {
        return new TimeArgument();
    }

    public static EffectArgument effect() {
        return new EffectArgument();
    }

    public static PrimitiveArgument<Direction.Axis> axis() {
        return new PrimitiveArgument.Builder<Direction.Axis>(string -> (Direction.Axis)EnumHelper.find((String)string, (Enum[])Direction.Axis.values(), Direction.Axis::m_122477_)).serializer(Direction.Axis::m_122477_).build();
    }

    public static PrimitiveArgument<EntityAnchorArgument.Anchor> anchor() {
        return new PrimitiveArgument.Builder<EntityAnchorArgument.Anchor>(string -> (EntityAnchorArgument.Anchor)EnumHelper.find((String)string, (Enum[])EntityAnchorArgument.Anchor.values(), anchor -> anchor.f_90367_)).serializer(anchor -> anchor.f_90367_).build();
    }

    public static PrimitiveArgument<Difficulty> difficulty() {
        return new PrimitiveArgument.Builder<Difficulty>(string -> (Difficulty)EnumHelper.find((String)string, (Enum[])Difficulty.values(), Difficulty::m_19036_)).serializer(Difficulty::m_19036_).build();
    }

    public static PrimitiveArgument<ObjectiveCriteria.RenderType> renderType() {
        return new PrimitiveArgument.Builder<ObjectiveCriteria.RenderType>(string -> (ObjectiveCriteria.RenderType)EnumHelper.find((String)string, (Enum[])ObjectiveCriteria.RenderType.values(), ObjectiveCriteria.RenderType::m_83633_)).serializer(ObjectiveCriteria.RenderType::m_83633_).build();
    }

    public static PrimitiveArgument<PrimitiveArgument.Operation> operation() {
        return new PrimitiveArgument.Builder<PrimitiveArgument.Operation>(string -> (PrimitiveArgument.Operation)EnumHelper.find((String)string, (Enum[])PrimitiveArgument.Operation.values(), PrimitiveArgument.Operation::toString)).build();
    }

    public static PrimitiveArgument<Component> textComponent() {
        return new PrimitiveArgument.Builder<Component>(string -> {
            try {
                return Component.Serializer.m_130701_((String)string);
            }
            catch (Exception e) {
                return new TextComponent(string);
            }
        }).serializer(Component.Serializer::m_130703_).build();
    }

    public static PrimitiveArgument<PrimitiveArgument.Relation> relation() {
        return new PrimitiveArgument.Builder<PrimitiveArgument.Relation>(string -> (PrimitiveArgument.Relation)EnumHelper.find((String)string, (Enum[])PrimitiveArgument.Relation.values(), PrimitiveArgument.Relation::toString)).build();
    }

    public static PrimitiveArgument<PrimitiveArgument.Type> type() {
        return new PrimitiveArgument.Builder<PrimitiveArgument.Type>(string -> (PrimitiveArgument.Type)EnumHelper.find((String)string, (Enum[])PrimitiveArgument.Type.values(), PrimitiveArgument.Type::toString)).build();
    }

    public static PrimitiveArgument<PrimitiveArgument.Linkage> linkage() {
        return new PrimitiveArgument.Builder<PrimitiveArgument.Linkage>(string -> (PrimitiveArgument.Linkage)EnumHelper.find((String)string, (Enum[])PrimitiveArgument.Linkage.values(), PrimitiveArgument.Linkage::toString)).build();
    }

    public static NbtPathArgument nbtPath() {
        return new NbtPathArgument();
    }

    public static ItemPredicateArgument itemPredicate() {
        return new ItemPredicateArgument();
    }

    public static PrimitiveArgument<String> criteria() {
        return new PrimitiveArgument.Builder<String>(string -> string == null || string.isBlank() ? null : string).serializer(string -> string.isBlank() ? null : string.replaceAll(" ", "_")).defaultOverride(string -> string == null || string.isBlank()).build();
    }

    public static TargetArgument target() {
        return new TargetArgument();
    }

    public static BlockPosArgument blockPos() {
        return new BlockPosArgument();
    }
}

