/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.TagArgument;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateArgument
extends TagArgument {
    private BlockState state;

    protected BlockStateArgument() {
    }

    public void set(@Nullable ResourceLocation block) {
        if (block != null) {
            this.set((Block)ForgeRegistries.BLOCKS.getValue(block));
        } else {
            this.state = null;
        }
    }

    public void set(@Nullable Block block) {
        this.state = block != null ? block.m_49966_() : null;
    }

    public void set(@Nullable BlockState state) {
        this.state = state;
    }

    public void set(@Nullable BlockState state, CompoundTag tag) {
        this.set(state);
        this.setTag(tag);
    }

    @Nullable
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public void deserialize(@Nullable String block) {
        if (block == null) {
            this.reset();
        } else {
            try {
                BlockStateParser parser = new BlockStateParser(new StringReader(block), false).m_116806_(true);
                this.state = parser.m_116808_();
                this.setTag(parser.m_116815_());
            }
            catch (CommandSyntaxException e) {
                this.reset();
            }
        }
    }

    private void reset() {
        this.state = null;
        this.setTag(null);
    }

    @Override
    @Nullable
    public String serialize() {
        if (this.state == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.state.toString());
        String block = this.state.m_60734_().toString();
        builder.replace(0, block.length(), this.state.m_60734_().getRegistryName().toString());
        String nbt = super.serialize();
        if (nbt != null && this.state.m_155947_()) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public boolean isDefault() {
        return super.isDefault() && this.state == null;
    }
}

