/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import exopandora.worldhandler.builder.argument.IDeserializableArgument;
import exopandora.worldhandler.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class EntitySummonArgument
implements IDeserializableArgument {
    private static final Map<String, ResourceLocation> ALIASES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put("RedCow", EntityType.f_20504_.getRegistryName());
        map.put("ChickenJockey", EntityType.f_20555_.getRegistryName());
        map.put("Pigman", EntityType.f_20511_.getRegistryName());
        map.put("ZombiePig", EntityType.f_20511_.getRegistryName());
        map.put("ZombiePigman", EntityType.f_20511_.getRegistryName());
        map.put("Dog", EntityType.f_20499_.getRegistryName());
        map.put("Dragon", EntityType.f_20565_.getRegistryName());
        map.put("SnowMan", EntityType.f_20528_.getRegistryName());
        map.put("LavaCube", EntityType.f_20468_.getRegistryName());
        map.put("MagmaSlime", EntityType.f_20468_.getRegistryName());
        map.put("LavaSlime", EntityType.f_20468_.getRegistryName());
        map.put("SpiderJockey", EntityType.f_20479_.getRegistryName());
        map.put("VillagerGolem", EntityType.f_20460_.getRegistryName());
        map.put("Ozelot", EntityType.f_20505_.getRegistryName());
        map.put("Kitty", EntityType.f_20553_.getRegistryName());
        map.put("Kitten", EntityType.f_20553_.getRegistryName());
        map.put("TESTIFICATE", EntityType.f_20492_.getRegistryName());
        map.put("Octopus", EntityType.f_20480_.getRegistryName());
        map.put("GlowingOctopus", EntityType.f_20480_.getRegistryName());
        map.put("Exwife", EntityType.f_20453_.getRegistryName());
        map.put("CommandMinecart", EntityType.f_20471_.getRegistryName());
        map.put("Wizard", EntityType.f_20568_.getRegistryName());
        map.put("Johnny", EntityType.f_20493_.getRegistryName());
        map.put("BabyZombie", EntityType.f_20501_.getRegistryName());
        ForgeRegistries.PROFESSIONS.getKeys().stream().forEach(profession -> map.put(profession.m_135815_(), EntityType.f_20492_.getRegistryName()));
    });
    private EntityType<?> entity;

    protected EntitySummonArgument() {
    }

    public void set(@Nullable EntityType<?> entity) {
        this.entity = entity != null && entity.m_20654_() ? entity : null;
    }

    public void set(@Nullable ResourceLocation entity) {
        if (entity != null) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
            if (!ForgeRegistries.ENTITIES.getDefaultKey().equals((Object)type.getRegistryName()) || type.getRegistryName().equals((Object)entity)) {
                this.set(type);
            } else {
                this.entity = null;
            }
        } else {
            this.entity = null;
        }
    }

    @Nullable
    public EntityType<?> getEntity() {
        return this.entity;
    }

    @Override
    public void deserialize(@Nullable String entity) {
        if (entity == null) {
            this.entity = null;
        } else {
            String stripped = entity.replace(" ", "");
            for (Map.Entry<String, ResourceLocation> entry : ALIASES.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(stripped)) continue;
                this.set(entry.getValue());
                return;
            }
            this.set(ResourceHelper.stringToResourceLocation(entity));
        }
    }

    @Override
    @Nullable
    public String serialize() {
        if (this.entity == null) {
            return null;
        }
        return this.entity.getRegistryName().toString();
    }

    @Override
    public boolean isDefault() {
        return this.entity == null;
    }
}

