/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.TagArgument;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemPredicateArgument
extends TagArgument {
    private ResourceLocation resource;
    private boolean isTag;

    protected ItemPredicateArgument() {
    }

    public void set(@Nullable ResourceLocation resource) {
        this.resource = resource;
    }

    public void set(@Nullable Item item) {
        this.resource = item != null ? item.getRegistryName() : null;
        this.isTag = false;
    }

    @Nullable
    public ResourceLocation getResourceLocation() {
        return this.resource;
    }

    public boolean isTag() {
        return this.isTag;
    }

    @Override
    public void deserialize(@Nullable String predicate) {
        if (predicate == null) {
            this.reset();
        } else {
            try {
                ItemParser parser = new ItemParser(new StringReader(predicate), true).m_121032_();
                if (parser.m_121014_() != null) {
                    this.resource = parser.m_121014_().getRegistryName();
                    this.setTag(parser.m_121018_());
                    this.isTag = false;
                } else {
                    this.resource = parser.m_205671_().f_203868_();
                    this.setTag(parser.m_121018_());
                    this.isTag = true;
                }
            }
            catch (CommandSyntaxException e) {
                this.reset();
            }
        }
    }

    private void reset() {
        this.resource = null;
        this.setTag(null);
        this.isTag = false;
    }

    @Override
    @Nullable
    public String serialize() {
        if (this.resource == null || this.resource.m_135815_().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (this.isTag) {
            builder.append('#');
        }
        builder.append(this.resource.toString());
        String nbt = super.serialize();
        if (nbt != null) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public boolean isDefault() {
        return super.isDefault() && this.resource == null;
    }
}

