/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.impl.CloneCommandBuilder;
import exopandora.worldhandler.builder.impl.FillCommandBuilder;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommandWH {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wh").then(Commands.m_82127_((String)"pos1").executes(context -> CommandWH.pos1((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"pos2").executes(context -> CommandWH.pos2((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fill").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_116120_()).executes(context -> CommandWH.fill((CommandSourceStack)context.getSource(), BlockStateArgument.m_116123_((CommandContext)context, (String)"block")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"replace").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_115570_()).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_116120_()).executes(context -> CommandWH.replace((CommandSourceStack)context.getSource(), CommandWH.getCommandNode("filter", context.getNodes()).getRange().get(context.getInput()), BlockStateArgument.m_116123_((CommandContext)context, (String)"block"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clone").requires(source -> source.m_6761_(2))).executes(context -> CommandWH.clone((CommandSourceStack)context.getSource(), "masked", null))).then(Commands.m_82127_((String)"filtered").then(Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_115570_()).executes(context -> CommandWH.clone((CommandSourceStack)context.getSource(), "filter", CommandWH.getCommandNode("filter", context.getNodes()).getRange().get(context.getInput())))))).then(Commands.m_82127_((String)"masked").executes(context -> CommandWH.clone((CommandSourceStack)context.getSource(), "masked", null)))).then(Commands.m_82127_((String)"replace").executes(context -> CommandWH.clone((CommandSourceStack)context.getSource(), "replace", null)))));
    }

    private static int pos1(CommandSourceStack source) throws CommandSyntaxException {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockHelper.pos1().m_122190_((Vec3i)BlockHelper.getFocusedBlockPos());
            BlockPos.MutableBlockPos pos = BlockHelper.pos1();
            ResourceLocation block = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)BlockHelper.getBlock((BlockPos)pos));
            CommandHelper.sendFeedback(source, "Set first position to " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + " (" + block + ")");
        });
        return 1;
    }

    private static int pos2(CommandSourceStack source) throws CommandSyntaxException {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockHelper.pos2().m_122190_((Vec3i)BlockHelper.getFocusedBlockPos());
            BlockPos.MutableBlockPos pos = BlockHelper.pos2();
            ResourceLocation block = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)BlockHelper.getBlock((BlockPos)pos));
            CommandHelper.sendFeedback(source, "Set second position to " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + " (" + block + ")");
        });
        return 1;
    }

    private static int fill(CommandSourceStack source, BlockInput block) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FillCommandBuilder builder = new FillCommandBuilder();
            builder.from().set((BlockPos)BlockHelper.pos1());
            builder.to().set((BlockPos)BlockHelper.pos2());
            builder.block().set(block.m_114669_(), block.f_114664_);
            CommandHelper.sendCommand(source.m_81368_(), builder, (Object)FillCommandBuilder.Label.FILL);
        });
        return 1;
    }

    private static int replace(CommandSourceStack source, String filter, BlockInput block) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FillCommandBuilder builder = new FillCommandBuilder();
            builder.from().set((BlockPos)BlockHelper.pos1());
            builder.to().set((BlockPos)BlockHelper.pos2());
            builder.block().set(block.m_114669_(), block.f_114664_);
            builder.filter().deserialize(filter);
            CommandHelper.sendCommand(source.m_81368_(), builder, (Object)FillCommandBuilder.Label.REPLACE);
        });
        return 1;
    }

    private static int clone(CommandSourceStack source, String mask, String filter) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CloneCommandBuilder builder = new CloneCommandBuilder();
            builder.begin().set((BlockPos)BlockHelper.pos1());
            builder.end().set((BlockPos)BlockHelper.pos2());
            builder.destination().setX(new Coordinate.Ints(Coordinate.Type.RELATIVE));
            builder.destination().setY(new Coordinate.Ints(Coordinate.Type.RELATIVE));
            builder.destination().setZ(new Coordinate.Ints(Coordinate.Type.RELATIVE));
            switch (mask) {
                case "filtered": {
                    builder.filter().deserialize(filter);
                    CommandHelper.sendCommand(source.m_81368_(), builder, (Object)CloneCommandBuilder.Label.FILTERED);
                    break;
                }
                case "masked": {
                    CommandHelper.sendCommand(source.m_81368_(), builder, (Object)CloneCommandBuilder.Label.MASKED);
                    break;
                }
                case "replace": {
                    CommandHelper.sendCommand(source.m_81368_(), builder, (Object)CloneCommandBuilder.Label.REPLACE);
                }
            }
        });
        return 1;
    }

    @Nullable
    private static <T> ParsedCommandNode<T> getCommandNode(String name, List<ParsedCommandNode<T>> nodes) {
        for (ParsedCommandNode<T> node : nodes) {
            if (!name.equals(node.getNode().getName())) continue;
            return node;
        }
        return null;
    }
}

