/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentButcher;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHelper;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentButcherPresets
extends ContentChild {
    private IContent.CommandPreview preview;
    private double radius;

    public ContentButcherPresets withBuilder(ICommandBuilder builder, Object label) {
        this.preview = new IContent.CommandPreview(builder, label);
        return this;
    }

    public ContentButcherPresets withRadius(double radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 58, y, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.butcher.presets.passive_mobs"), () -> {
            ContentButcher.slaughter(container.getPlayer(), ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> !MobCategory.MONSTER.equals((Object)entity.m_20674_()) && !MobCategory.MISC.equals((Object)entity.m_20674_())).collect(Collectors.toList()), this.radius);
            ActionHelper.open(this.getParentContent());
        }));
        container.add(new GuiButtonBase(x + 58, y + 24, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.butcher.presets.hostile_mobs"), () -> {
            ContentButcher.slaughter(container.getPlayer(), ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> MobCategory.MONSTER.equals((Object)entity.m_20674_())).collect(Collectors.toList()), this.radius);
            ActionHelper.open(this.getParentContent());
        }));
        container.add(new GuiButtonBase(x + 58, y + 48, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.butcher.presets.players"), () -> {
            ContentButcher.slaughter(container.getPlayer(), ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> EntityType.f_20532_.equals(entity)).collect(Collectors.toList()), this.radius);
            ActionHelper.open(this.getParentContent());
        }));
        container.add(new GuiButtonBase(x + 58, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.butcher.presets.entities"), () -> {
            ContentButcher.slaughter(container.getPlayer(), ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> MobCategory.MISC.equals((Object)entity.m_20674_()) && !EntityType.f_20532_.equals(entity)).collect(Collectors.toList()), this.radius);
            ActionHelper.open(this.getParentContent());
        }));
    }
}

