/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.impl.GiveCommandBuilder;
import exopandora.worldhandler.builder.impl.SetBlockCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonItem;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ContentContainers
extends Content {
    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 232, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 24, y, 208, 20, (Component)Blocks.f_50091_.m_49954_(), () -> this.placeBlock(container.getPlayer(), Blocks.f_50091_)));
        container.add(new GuiButtonBase(x + 24, y + 24, 208, 20, (Component)Blocks.f_50265_.m_49954_(), () -> this.placeBlock(container.getPlayer(), Blocks.f_50265_)));
        container.add(new GuiButtonBase(x + 24, y + 48, 208, 20, (Component)Blocks.f_50322_.m_49954_(), () -> this.placeBlock(container.getPlayer(), Blocks.f_50322_)));
        container.add(new GuiButtonBase(x + 24, y + 72, 208, 20, (Component)Blocks.f_50201_.m_49954_(), () -> {
            double angle = (double)Minecraft.m_91087_().f_91074_.m_6350_().m_122416_() * Math.PI / 2.0;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                for (int yOffset = 0; yOffset <= 1; ++yOffset) {
                    block7: for (int zOffset = 1; zOffset <= 4; ++zOffset) {
                        Block block = null;
                        int cx = (int)Math.round((double)xOffset * cos - (double)zOffset * sin);
                        int cz = (int)Math.round((double)xOffset * sin + (double)zOffset * cos);
                        if (xOffset < -1 || xOffset > 1 || zOffset >= 4) {
                            block = Blocks.f_50078_;
                        } else {
                            if (xOffset != 0 || yOffset != 0 || zOffset != 2) continue;
                            block = Blocks.f_50201_;
                        }
                        SetBlockCommandBuilder builder = new SetBlockCommandBuilder();
                        builder.pos().setX(new Coordinate.Ints(cx, Coordinate.Type.RELATIVE));
                        builder.pos().setY(new Coordinate.Ints(yOffset, Coordinate.Type.RELATIVE));
                        builder.pos().setZ(new Coordinate.Ints(cz, Coordinate.Type.RELATIVE));
                        builder.block().set(block);
                        switch (Config.getSettings().getBlockPlacingMode()) {
                            case KEEP: {
                                CommandHelper.sendCommand(container.getPlayer(), builder, (Object)SetBlockCommandBuilder.Label.KEEP);
                                continue block7;
                            }
                            case REPLACE: {
                                CommandHelper.sendCommand(container.getPlayer(), builder, (Object)SetBlockCommandBuilder.Label.REPLACE);
                                continue block7;
                            }
                            case DESTROY: {
                                CommandHelper.sendCommand(container.getPlayer(), builder, (Object)SetBlockCommandBuilder.Label.DESTROY);
                            }
                        }
                    }
                }
            }
            ActionHelper.backToGame();
        }));
        container.add(new GuiButtonItem(x, y, 20, 20, new ItemStack((ItemLike)Blocks.f_50091_), () -> this.giveItem(container.getPlayer(), Items.f_41960_)));
        container.add(new GuiButtonItem(x, y + 24, 20, 20, new ItemStack((ItemLike)Blocks.f_50265_), () -> this.giveItem(container.getPlayer(), Items.f_42108_)));
        container.add(new GuiButtonItem(x, y + 48, 20, 20, new ItemStack((ItemLike)Blocks.f_50322_), () -> this.giveItem(container.getPlayer(), Items.f_42146_)));
        container.add(new GuiButtonItem(x, y + 72, 20, 20, new ItemStack((ItemLike)Blocks.f_50201_), () -> this.giveItem(container.getPlayer(), Items.f_42100_)));
    }

    private void giveItem(String player, Item item) {
        GiveCommandBuilder builder = new GiveCommandBuilder();
        builder.targets().setTarget(player);
        builder.item().set(item);
        CommandHelper.sendCommand(player, builder, (Object)GiveCommandBuilder.Label.GIVE);
    }

    private void placeBlock(String player, Block block) {
        BlockHelper.setBlockNearPlayer(player, block);
        ActionHelper.backToGame();
    }

    @Override
    public Category getCategory() {
        return Categories.MAIN;
    }

    @Override
    public MutableComponent getTitle() {
        return new TranslatableComponent("gui.worldhandler.title.containers");
    }

    @Override
    public MutableComponent getTabTitle() {
        return new TranslatableComponent("gui.worldhandler.tab.containers");
    }

    @Override
    public Content getActiveContent() {
        return Contents.CONTAINERS;
    }

    @Override
    public Content getBackContent() {
        return null;
    }
}

