/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.argument.tag.CustomPotionEffectsTag;
import exopandora.worldhandler.builder.argument.tag.EffectInstance;
import exopandora.worldhandler.builder.impl.EffectCommandBuilder;
import exopandora.worldhandler.builder.impl.GiveCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentPotions
extends ContentChild {
    private final EffectCommandBuilder builderPotion = new EffectCommandBuilder();
    private final CustomPotionEffectsTag effects = new CustomPotionEffectsTag();
    private final GiveCommandBuilder builderPotionItem = new GiveCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview().add(this.builderPotion, (Object)EffectCommandBuilder.Label.GIVE_SECONDS_AMPLIFIER_HIDEPARTICLES).add(this.builderPotionItem, (Object)GiveCommandBuilder.Label.GIVE_COUNT);
    private int potionPage;

    public ContentPotions() {
        this.builderPotionItem.item().addTagProvider(this.effects);
        this.builderPotion.amplifier().set((byte)0);
        this.builderPotion.hideParticles().set(false);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPotion.amplifier().get().byteValue() > Config.getSliders().getMaxPotionAmplifier()) {
            this.builderPotion.amplifier().set((byte)Config.getSliders().getMaxPotionAmplifier());
        }
        for (MobEffect effect : this.effects.getMobEffects()) {
            EffectInstance tag = this.effects.getOrCreate(effect);
            if (!((double)tag.getAmplifier() > Config.getSliders().getMaxPotionAmplifier())) continue;
            tag.setAmplifier((byte)Config.getSliders().getMaxPotionAmplifier());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        MenuPageList<MobEffect> potions = new MenuPageList<MobEffect>(x, y, new ArrayList(ForgeRegistries.MOB_EFFECTS.getValues()), 114, 20, 3, container, new ILogicPageList<MobEffect>(){

            @Override
            public MutableComponent translate(MobEffect effect) {
                return new TranslatableComponent(effect.m_19481_());
            }

            @Override
            public MutableComponent toTooltip(MobEffect effect) {
                return new TextComponent(effect.getRegistryName().toString());
            }

            @Override
            public void onClick(MobEffect effect) {
                ContentPotions.this.builderPotion.effect().set(effect);
                for (MobEffect entry : ContentPotions.this.effects.getMobEffects()) {
                    if (entry.equals(effect)) continue;
                    ContentPotions.this.effects.remove(entry);
                }
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, MobEffect effect, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(effect), actionHandler);
            }

            @Override
            public String getId() {
                return "potions";
            }
        });
        container.add(potions);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonBase button1;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.potionPage == 0) {
            container.add(new GuiButtonBase(x + 118, y + 12, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.give"), () -> this.next(container)));
            container.add(new GuiButtonBase(x + 118, y + 36, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.CLEAR_TARGETS_EFFECT);
                container.m_7856_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 60, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.remove_all"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.CLEAR);
                container.m_7856_();
            }));
        } else if (this.potionPage == 1) {
            MobEffect effect = this.builderPotion.effect().getEffect();
            EffectInstance tag = this.effects.getOrCreate(effect);
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.ambient", new Object[]{tag.isAmbient() ? new TranslatableComponent("gui.worldhandler.generic.on") : new TranslatableComponent("gui.worldhandler.generic.off")}), () -> {
                tag.setAmbient(!tag.isAmbient());
                container.m_7856_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.particles", new Object[]{this.builderPotion.hideParticles().get() != false ? new TranslatableComponent("gui.worldhandler.generic.off") : new TranslatableComponent("gui.worldhandler.generic.on")}), () -> {
                this.builderPotion.hideParticles().set(this.builderPotion.hideParticles().get() == false);
                tag.setShowParticles(!tag.doShowParticles());
                container.m_7856_();
            }));
            container.add(new GuiSlider(x + 118, y, 114, 20, 1.0, Config.getSliders().getMaxPotionAmplifier(), 1.0, container, new LogicSliderSimple("amplifier" + effect.getRegistryName(), (MutableComponent)new TranslatableComponent("gui.worldhandler.potions.effect.amplifier"), value -> {
                this.builderPotion.amplifier().set((byte)(value.byteValue() - 1));
                tag.setAmplifier(value.byteValue());
            })));
        } else if (this.potionPage == 2) {
            MobEffect effect = this.builderPotion.effect().getEffect();
            EffectInstance tag = this.effects.getOrCreate(effect);
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("s" + effect.getRegistryName(), (MutableComponent)new TranslatableComponent("gui.worldhandler.potion.time.seconds"), value -> {
                tag.setSeconds((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("m" + effect.getRegistryName(), (MutableComponent)new TranslatableComponent("gui.worldhandler.potion.time.minutes"), value -> {
                tag.setMinutes((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
            container.add(new GuiSlider(x + 118, y + 48, 114, 20, 0.0, 99.0, 0.0, container, new LogicSliderSimple("h" + effect.getRegistryName(), (MutableComponent)new TranslatableComponent("gui.worldhandler.potion.time.hours"), value -> {
                tag.setHours((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
        } else if (this.potionPage == 3) {
            boolean enabled;
            button1 = new GuiButtonBase(x + 118, y, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.GIVE_SECONDS_AMPLIFIER_HIDEPARTICLES);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 24, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.tipped_arrow"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42738_, 0.125f);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button2);
            GuiButtonTooltip button3 = new GuiButtonTooltip(x + 178, y + 24, 55, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.bottle"), (Component)new TranslatableComponent("gui.worldhandler.actions.place_command_block"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42589_, 1.0f);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button3);
            GuiButtonTooltip button4 = new GuiButtonTooltip(x + 118, y + 48, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.splash"), (Component)new TranslatableComponent("gui.worldhandler.actions.place_command_block"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42736_, 1.0f);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button4);
            GuiButtonTooltip button5 = new GuiButtonTooltip(x + 178, y + 48, 55, 20, (Component)new TranslatableComponent("gui.worldhandler.potions.effect.lingering"), (Component)new TranslatableComponent("gui.worldhandler.actions.place_command_block"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42739_, 0.25f);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button5);
            button1.f_93623_ = enabled = this.builderPotion.amplifier().get() >= 0 && this.builderPotion.seconds().get() > 0;
            button2.f_93623_ = enabled;
            button3.f_93623_ = enabled;
            button4.f_93623_ = enabled;
            button5.f_93623_ = enabled;
        }
        if (this.potionPage > 0) {
            container.add(new GuiButtonBase(x + 118, y + 72, 56, 20, (Component)TextUtils.ARROW_LEFT, () -> {
                --this.potionPage;
                container.m_7856_();
            }));
            button1 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, (Component)TextUtils.ARROW_RIGHT, () -> this.next(container));
            container.add(button1);
            button1.f_93623_ = this.potionPage < 3;
        }
    }

    private void next(Container container) {
        ++this.potionPage;
        container.m_7856_();
    }

    private void giveItem(String player, Item item, float modifier) {
        CustomPotionEffectsTag effects = new CustomPotionEffectsTag();
        MobEffect effect = this.builderPotion.effect().getEffect();
        EffectInstance tag = effects.getOrCreate(effect);
        EffectInstance original = this.effects.getOrCreate(effect);
        tag.setAmbient(original.isAmbient());
        tag.setAmplifier(original.getAmplifier());
        tag.setHours((int)((float)original.getHours() / modifier));
        tag.setMinutes((int)((float)original.getMinutes() / modifier));
        tag.setSeconds((int)((float)original.getSeconds() / modifier));
        tag.setShowParticles(original.doShowParticles());
        GiveCommandBuilder builder = new GiveCommandBuilder();
        builder.targets().setTarget(this.builderPotionItem.targets().getTarget());
        builder.item().set(item);
        builder.item().addTagProvider(effects);
        CommandHelper.sendCommand(player, builder, (Object)GiveCommandBuilder.Label.GIVE);
    }

    @Override
    public MutableComponent getTitle() {
        return new TranslatableComponent("gui.worldhandler.title.potions");
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPotion.targets().setTarget(username);
        this.builderPotionItem.targets().setTarget(username);
    }
}

