/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.impl.ScoreboardCommandBuilder;
import exopandora.worldhandler.builder.impl.TagCommandBuilder;
import exopandora.worldhandler.builder.impl.TriggerCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ContentScoreboardPlayers
extends ContentScoreboard {
    private final TagCommandBuilder builderTag = new TagCommandBuilder();
    private final TriggerCommandBuilder builderTrigger = new TriggerCommandBuilder();
    private final IContent.CommandPreview previewPlayers = new IContent.CommandPreview(BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS);
    private final IContent.CommandPreview previewTag = new IContent.CommandPreview(this.builderTag, null);
    private final IContent.CommandPreview previewTrigger = new IContent.CommandPreview().add(this.builderTrigger, null).add(BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS_ENABLE_OBJECTIVE);
    private Page page = Page.ADD_SET_REMOVE;
    private GuiButtonBase addButton;
    private GuiButtonBase removeButton;
    private GuiTextFieldTooltip objectField;
    private GuiTextFieldTooltip tagField;

    public ContentScoreboardPlayers() {
        this.builderTrigger.value().set(0);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        switch (this.page) {
            case ADD_SET_REMOVE: {
                return this.previewPlayers;
            }
            case ENABLE: {
                return this.previewTrigger;
            }
            case TAG: {
                return this.previewTag;
            }
        }
        return null;
    }

    @Override
    public void init(Container container) {
        if ((double)BUILDER.score().get().intValue() > Config.getSliders().getMaxPlayerPoints()) {
            BUILDER.score().set((int)Config.getSliders().getMaxPlayerPoints());
        }
        if ((double)this.builderTrigger.value().get().intValue() > Config.getSliders().getMaxTriggerValue()) {
            this.builderTrigger.value().set((int)Config.getSliders().getMaxTriggerValue());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.scoreboard.objectives.objective"));
        this.objectField.m_94153_((Predicate)Predicates.notNull());
        this.objectField.m_94151_(text -> {
            BUILDER.objective().set((String)text);
            BUILDER.displayName().deserialize((String)text);
            this.builderTrigger.objective().set((String)text);
            container.initButtons();
        });
        this.objectField.m_94144_(BUILDER.objective().get());
        this.tagField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.scoreboard.players.tag"));
        this.tagField.m_94153_(string -> string != null && !string.contains(" "));
        this.tagField.m_94144_(this.builderTag.name().get());
        this.tagField.m_94151_(text -> {
            this.builderTag.name().set((String)text);
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y + 12, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.scoreboard.players.points"), () -> {
            this.page = Page.ADD_SET_REMOVE;
            container.m_7856_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 36, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.scoreboard.players.tag"), () -> {
            this.page = Page.TAG;
            container.m_7856_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 60, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.scoreboard.players.trigger"), () -> {
            this.page = Page.ENABLE;
            container.m_7856_();
        });
        container.add(button3);
        button1.f_93623_ = !Page.ADD_SET_REMOVE.equals((Object)this.page);
        button2.f_93623_ = !Page.TAG.equals((Object)this.page);
        button3.f_93623_ = !Page.ENABLE.equals((Object)this.page);
        boolean bl = enabled = BUILDER.objective().get() != null && !BUILDER.objective().get().isEmpty();
        if (Page.ADD_SET_REMOVE.equals((Object)this.page)) {
            boolean score;
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxPlayerPoints(), 0.0, container, new LogicSliderSimple("points", (MutableComponent)new TranslatableComponent("gui.worldhandler.scoreboard.players.points"), value -> BUILDER.score().set((Integer)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.add"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS_ADD_SCORE);
                container.m_7856_();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS_REMOVE_SCORE);
                container.m_7856_();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonTooltip(x + 118, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.reset"), (Component)new TranslatableComponent("gui.worldhandler.actions.set_to_0"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS_RESET_SCORE);
                container.m_7856_();
            });
            container.add(button1);
            this.addButton.f_93623_ = score = enabled && BUILDER.score().get() > 0;
            this.removeButton.f_93623_ = score;
            button1.f_93623_ = enabled;
        } else if (Page.TAG.equals((Object)this.page)) {
            boolean tag;
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.add"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTag, (Object)TagCommandBuilder.Label.ADD);
                container.m_7856_();
            });
            container.add(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTag, (Object)TagCommandBuilder.Label.REMOVE);
                container.m_7856_();
            });
            container.add(button2);
            button1.f_93623_ = tag = this.builderTag.name().get() != null && !this.builderTag.name().get().isEmpty();
            button2.f_93623_ = tag;
        } else if (Page.ENABLE.equals((Object)this.page)) {
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxTriggerValue(), 0.0, container, new LogicSliderSimple("enable", (MutableComponent)new TranslatableComponent("gui.worldhandler.generic.value"), value -> this.builderTrigger.value().set((Integer)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.add"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTrigger, (Object)TriggerCommandBuilder.Label.ADD);
                container.m_7856_();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.set"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTrigger, (Object)TriggerCommandBuilder.Label.SET);
                container.m_7856_();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.enable"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), BUILDER, (Object)ScoreboardCommandBuilder.Label.PLAYERS_ENABLE_OBJECTIVE);
                container.m_7856_();
            });
            container.add(button1);
            this.addButton.f_93623_ = enabled && this.builderTrigger.value().get() > 0;
            this.removeButton.f_93623_ = enabled;
            button1.f_93623_ = enabled;
        }
        if (Page.TAG.equals((Object)this.page)) {
            container.add(this.tagField);
        } else {
            container.add(this.objectField);
        }
    }

    @Override
    public void tick(Container container) {
        if (Page.TAG.equals((Object)this.page)) {
            this.tagField.m_94120_();
        } else {
            boolean enabled;
            boolean bl = enabled = BUILDER.objective().get() != null && !BUILDER.objective().get().isEmpty();
            if (Page.ADD_SET_REMOVE.equals((Object)this.page)) {
                boolean points;
                this.addButton.f_93623_ = points = enabled && BUILDER.score().get() > 0;
                this.removeButton.f_93623_ = points;
            } else if (Page.ENABLE.equals((Object)this.page)) {
                this.addButton.f_93623_ = enabled && this.builderTrigger.value().get() > 0;
                this.removeButton.f_93623_ = enabled;
            }
            this.objectField.m_94120_();
        }
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.TAG.equals((Object)this.page)) {
            this.tagField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        } else {
            this.objectField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public MutableComponent getTabTitle() {
        return new TranslatableComponent("gui.worldhandler.tab.scoreboard.players");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_PLAYERS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        BUILDER.targets().setTarget(username);
        this.builderTag.targets().setTarget(username);
    }

    public static enum Page {
        ADD_SET_REMOVE,
        TAG,
        ENABLE;

    }
}

