/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.argument.PrimitiveArgument;
import exopandora.worldhandler.builder.argument.tag.TextTag;
import exopandora.worldhandler.builder.impl.DataCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicColorMenu;
import exopandora.worldhandler.gui.widget.menu.impl.MenuColorField;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SignBlock;

public class ContentSignEditor
extends Content {
    private final DataCommandBuilder builderSignEditor = new DataCommandBuilder();
    private final TextTag[] texts = new TextTag[4];
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderSignEditor, (Object)DataCommandBuilder.Label.MERGE_BLOCK);
    private GuiTextFieldTooltip commandField;
    private int selectedLine;
    private boolean editColor;
    private boolean isActive;

    public ContentSignEditor() {
        this.builderSignEditor.linkage().set(PrimitiveArgument.Linkage.MERGE);
        for (int x = 0; x < this.texts.length; ++x) {
            TextTag text;
            this.texts[x] = text = new TextTag(x + 1);
            this.builderSignEditor.nbt().addTagProvider(text);
        }
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.isActive ? this.preview : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.getFocusedBlock() instanceof SignBlock;
        this.builderSignEditor.targetPos().set(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initGui(Container container, int x, int y) {
        if (this.isActive) {
            this.commandField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.commmand"));
            this.commandField.m_94153_((Predicate)Predicates.notNull());
            this.commandField.m_94144_(this.texts[this.selectedLine].getText().getCommand());
            this.commandField.m_94201_();
            this.commandField.m_94151_(text -> {
                this.texts[this.selectedLine].getText().setCommand((String)text);
                container.initButtons();
            });
            MenuColorField colors = new MenuColorField(x, y, "gui.worldhandler.blocks.sign_editor.text_line_" + (this.selectedLine + 1), this.texts[this.selectedLine].getText(), new ILogicColorMenu(){

                @Override
                public boolean validate(String text) {
                    return Minecraft.m_91087_().f_91062_.m_92895_(text) <= 90;
                }

                @Override
                public boolean doDrawButtons() {
                    return ContentSignEditor.this.editColor;
                }

                @Override
                public String getId() {
                    return "color" + ContentSignEditor.this.selectedLine;
                }
            });
            container.add(colors);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.isActive) {
            GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.text_line_1"), () -> {
                this.selectedLine = 0;
                container.m_7856_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.text_line_2"), () -> {
                this.selectedLine = 1;
                container.m_7856_();
            });
            container.add(button2);
            GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.text_line_3"), () -> {
                this.selectedLine = 2;
                container.m_7856_();
            });
            container.add(button3);
            GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.text_line_4"), () -> {
                this.selectedLine = 3;
                container.m_7856_();
            });
            container.add(button4);
            if (this.editColor) {
                container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.done"), () -> this.toggleEditColor(container)));
            } else {
                container.add(this.commandField);
                container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.blocks.sign_editor.format_text_line"), () -> this.toggleEditColor(container)));
                container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.actions.place_command_block"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderSignEditor, (Object)DataCommandBuilder.Label.MERGE_BLOCK, Arrays.stream(this.texts).anyMatch(text -> text.getText().isSpecial()))));
            }
            button1.f_93623_ = this.selectedLine != 0;
            button2.f_93623_ = this.selectedLine != 1;
            button3.f_93623_ = this.selectedLine != 2;
            button4.f_93623_ = this.selectedLine != 3;
        }
    }

    @Override
    public void tick(Container container) {
        if (this.isActive && !this.editColor) {
            this.commandField.m_94120_();
        }
    }

    private void toggleEditColor(Container container) {
        this.editColor = !this.editColor;
        container.m_7856_();
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            if (!this.editColor) {
                this.commandField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            }
        } else {
            float scale = 4.0f;
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)((float)(container.f_96543_ / 2) - 8.5f * scale), (double)((float)(container.f_96544_ / 2 - 15) - 8.5f * scale), 0.0);
            posestack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)Items.f_42438_), 0, 0);
            posestack.m_85849_();
            RenderSystem.m_157182_();
            TranslatableComponent text = new TranslatableComponent("gui.worldhandler.blocks.sign_editor.look_at_sign", new Object[]{KeyHandler.KEY_WORLD_HANDLER.m_90863_()});
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(matrix, (Component)text, (float)(x + 116 - font.m_92852_((FormattedText)text) / 2), (float)(y + 70), Config.getSkin().getLabelColor());
        }
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public MutableComponent getTitle() {
        return new TranslatableComponent("gui.worldhandler.title.blocks.sign_editor");
    }

    @Override
    public MutableComponent getTabTitle() {
        return new TranslatableComponent("gui.worldhandler.tab.blocks.sign_editor");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SIGN_EDITOR;
    }
}

