/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;

public class ContentWorldInfo
extends Content {
    private Page page = Page.START;
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip worldField;
    private GuiTextFieldTooltip seedField;
    private GuiTextFieldTooltip totalTimeField;
    private GuiTextFieldTooltip currentTimeField;

    @Override
    public void initGui(Container container, int x, int y) {
        Level level = ContentWorldInfo.getSidedWorld();
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        this.posXField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.posXField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " X: " + ContentWorldInfo.format(level, object -> object.m_6106_().m_6789_()));
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.posYField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Y: " + ContentWorldInfo.format(level, object -> object.m_6106_().m_6527_()));
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.posZField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Z: " + ContentWorldInfo.format(level, object -> object.m_6106_().m_6526_()));
        this.worldField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.worldField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.world.name", (Object[])new Object[0]) + ": " + ContentWorldInfo.format(server, object -> object.m_129910_().m_5462_()));
        this.seedField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.seedField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.world.seed", (Object[])new Object[0]) + ": " + ContentWorldInfo.format(server, object -> object.m_129783_().m_7328_()));
        this.seedField.m_94153_(string -> string.equals(this.seedField.m_94155_()));
        this.seedField.m_94198_();
        this.currentTimeField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.updateCurrentTime();
        this.totalTimeField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.updateTotalTime();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase start = new GuiButtonBase(x, y + 12, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.world_info.start"), () -> {
            this.page = Page.START;
            container.m_7856_();
        });
        container.add(start);
        GuiButtonBase world = new GuiButtonBase(x, y + 36, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.world_info.world"), () -> {
            this.page = Page.WORLD;
            container.m_7856_();
        });
        container.add(world);
        GuiButtonBase stats = new GuiButtonBase(x, y + 60, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.world_info.statistics"), () -> {
            this.page = Page.STATS;
            container.m_7856_();
        });
        container.add(stats);
        if (Page.START.equals((Object)this.page)) {
            start.f_93623_ = false;
        } else if (Page.WORLD.equals((Object)this.page)) {
            IntegratedServer server = Minecraft.m_91087_().m_91092_();
            world.f_93623_ = false;
            GuiButtonBase seed = new GuiButtonBase(x + 118, y + 60, 114, 20, (Component)new TranslatableComponent("gui.worldhandler.world_info.world.copy_seed"), () -> Minecraft.m_91087_().f_91068_.m_90911_(String.valueOf(server.m_129783_().m_7328_())));
            container.add(seed);
            seed.f_93623_ = server != null;
        } else if (Page.STATS.equals((Object)this.page)) {
            stats.f_93623_ = false;
        }
    }

    @Override
    public void tick(Container container) {
        this.updateCurrentTime();
        this.updateTotalTime();
        this.seedField.m_94120_();
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            this.posXField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.posYField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.posZField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.WORLD.equals((Object)this.page)) {
            this.worldField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.seedField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.STATS.equals((Object)this.page)) {
            this.totalTimeField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.currentTimeField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    private void updateCurrentTime() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.currentTimeField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.statistics.world_time", (Object[])new Object[0]) + ": " + TextUtils.formatWorldTime(level.m_6106_().m_6792_()));
        }
    }

    private void updateTotalTime() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.totalTimeField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.world_info.statistics.played", (Object[])new Object[0]) + ": " + TextUtils.formatTotalTime(level.m_6106_().m_6793_()));
        }
    }

    private static <T> String format(T object, Function<T, Object> function) {
        if (object != null) {
            return String.valueOf(function.apply(object));
        }
        return I18n.m_118938_((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0]);
    }

    private static Level getSidedWorld() {
        if (Minecraft.m_91087_().m_91090_()) {
            return Minecraft.m_91087_().m_91092_().m_129783_();
        }
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public MutableComponent getTitle() {
        return new TranslatableComponent("gui.worldhandler.title.world.world");
    }

    @Override
    public MutableComponent getTabTitle() {
        return new TranslatableComponent("gui.worldhandler.tab.world.world");
    }

    @Override
    public Content getActiveContent() {
        return Contents.WORLD_INFO;
    }

    public static enum Page {
        START,
        WORLD,
        STATS;

    }
}

