/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget;

import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.widget.IContainerWidget;
import exopandora.worldhandler.gui.widget.button.EnumIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonIcon;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class WidgetShortcuts
implements IContainerWidget {
    @Override
    public void initGui(Container container, int x, int y) {
        int start = container.f_96543_ / 2 - 157;
        EnumShortcuts[] shortcuts = EnumShortcuts.values();
        for (int i = 0; i < shortcuts.length; ++i) {
            EnumShortcuts shortcut = shortcuts[i];
            container.addWidget((AbstractWidget)new GuiButtonIcon(start + i * 21, 0, 20, 20, shortcut.getIcon(), shortcut.getTextSupplier().get(), shortcut.getActionHandler()));
        }
    }

    @Override
    public boolean isEnabled() {
        return Config.getSettings().shortcuts();
    }

    @Override
    public IContainerWidget.EnumLayer getLayer() {
        return IContainerWidget.EnumLayer.FOREGROUND;
    }

    public static enum EnumShortcuts {
        TIME_DAWN(EnumIcon.TIME_DAWN, ActionHelper::timeDawn, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time.dawn", new Object[]{Config.getSettings().getDawn()})})),
        TIME_NOON(EnumIcon.TIME_NOON, ActionHelper::timeNoon, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time.noon", new Object[]{Config.getSettings().getNoon()})})),
        TIME_SUNSET(EnumIcon.TIME_SUNSET, ActionHelper::timeSunset, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time.sunset", new Object[]{Config.getSettings().getSunset()})})),
        TIME_MIDNIGHT(EnumIcon.TIME_MIDNIGHT, ActionHelper::timeMidnight, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.time.midnight", new Object[]{Config.getSettings().getMidnight()})})),
        WEATHER_SUN(EnumIcon.WEATHER_SUN, ActionHelper::weatherClear, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather.clear")})),
        WEATHER_RAIN(EnumIcon.WEATHER_RAIN, ActionHelper::weatherRain, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather.rainy")})),
        WEATHER_STORM(EnumIcon.WEATHER_STORM, ActionHelper::weatherThunder, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.weather.thunder")})),
        DIFFICULTY_PEACEFUL(EnumIcon.DIFFICULTY_PEACEFUL, ActionHelper::difficultyPeaceful, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty.peaceful")})),
        DIFFICULTY_EASY(EnumIcon.DIFFICULTY_EASY, ActionHelper::difficultyEasy, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty.easy")})),
        DIFFICULTY_NORMAL(EnumIcon.DIFFICULTY_NORMAL, ActionHelper::difficultyNormal, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty.normal")})),
        DIFFICULTY_HARD(EnumIcon.DIFFICULTY_HARD, ActionHelper::difficultyHard, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.difficulty.hard")})),
        GAMEMODE_SURVIVAL(EnumIcon.GAMEMODE_SURVIVAL, ActionHelper::gamemodeSurvival, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode.survival")})),
        GAMEMODE_CREATIVE(EnumIcon.GAMEMODE_CREATIVE, ActionHelper::gamemodeCreative, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode.creative")})),
        GAMEMODE_ADVENTURE(EnumIcon.GAMEMODE_ADVENTURE, ActionHelper::gamemodeAdventure, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode.adventure")})),
        GAMEMODE_SPECTATOR(EnumIcon.GAMEMODE_SPECTATOR, ActionHelper::gamemodeSpectator, () -> new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode", new Object[]{new TranslatableComponent("gui.worldhandler.shortcuts.tooltip.gamemode.spectator")}));

        private final EnumIcon icon;
        private final Supplier<Component> text;
        private final ActionHandler actionHandler;

        private EnumShortcuts(EnumIcon icon, ActionHandler actionHandler, Supplier<Component> text) {
            this.icon = icon;
            this.text = text;
            this.actionHandler = actionHandler;
        }

        public EnumIcon getIcon() {
            return this.icon;
        }

        public Supplier<Component> getTextSupplier() {
            return this.text;
        }

        public ActionHandler getActionHandler() {
            return this.actionHandler;
        }
    }
}

