/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ILogic;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.TextUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class GuiSlider
extends GuiButtonBase {
    private final Persistence persistence;
    private final ILogicSlider logic;
    private final Container container;

    public GuiSlider(int x, int y, int widthIn, int heightIn, double min, double max, double start, Container container, ILogicSlider logic) {
        super(x, y, widthIn, heightIn, TextComponent.f_131282_, null);
        this.logic = Objects.requireNonNull(logic);
        this.container = Objects.requireNonNull(container);
        this.persistence = this.container.getContent().getPersistence(this.logic.getId(), () -> new Persistence(min, max, min == max ? 0.0 : (start - min) / (max - min)));
        this.persistence.validate(min, max);
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
        this.updateDisplayString();
    }

    @Override
    protected void m_7906_(PoseStack matrix, Minecraft minecraft, int mouseX, int mouseY) {
        super.m_7906_(matrix, minecraft, mouseX, mouseY);
        int hovered = super.m_7202_(this.m_198029_());
        int textureOffset = (Config.getSkin().getTextureType().equals("resourcepack") ? 46 : 0) + hovered * 20;
        RenderSystem.m_69478_();
        RenderUtils.colorDefaultButton();
        this.m_93228_(matrix, this.f_93620_ + (int)(this.persistence.getValue() * (double)(this.f_93618_ - 8)), this.f_93621_, 0, textureOffset, 4, 20);
        this.m_93228_(matrix, this.f_93620_ + (int)(this.persistence.getValue() * (double)(this.f_93618_ - 8)) + 4, this.f_93621_, 196, textureOffset, 4, 20);
        RenderSystem.m_69461_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.updateSlider(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.updateSlider(mouseX);
        super.m_7212_(mouseX, mouseY, deltaX, deltaY);
    }

    protected void updateSlider(double mouseX) {
        this.persistence.setValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
        if (this.persistence.getValue() < 0.0) {
            this.persistence.setValue(0.0);
        }
        if (this.persistence.getValue() > 1.0) {
            this.persistence.setValue(1.0);
        }
        this.updateDisplayString();
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
    }

    protected int m_7202_(boolean mouseOver) {
        return 0;
    }

    private void updateDisplayString() {
        int value = this.persistence.getValueInt();
        MutableComponent suffix = this.logic.formatValue(value).m_7220_((Component)this.logic.formatSuffix(value));
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent text = TextUtils.stripText(this.logic.formatPrefix(value), this.f_93618_ - fontRenderer.m_92852_((FormattedText)suffix), fontRenderer).m_7220_((Component)suffix);
        this.m_93666_((Component)text);
    }

    public static interface ILogicSlider
    extends ILogic {
        public MutableComponent formatPrefix(int var1);

        public MutableComponent formatSuffix(int var1);

        public MutableComponent formatValue(int var1);

        public void onChangeSliderValue(int var1);
    }

    public class Persistence {
        private double min;
        private double max;
        private double value;

        private Persistence(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public Persistence(double min, double max, double value) {
            this(min, max);
            this.value = value;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int getValueInt() {
            return (int)Math.round(this.min + (this.max - this.min) * this.value);
        }

        public void setValueInt(int value) {
            this.value = this.intToValue(value);
        }

        public void validate(double min, double max) {
            if (this.getMin() != min || this.getMax() != max) {
                this.min = min;
                this.max = max;
            }
        }

        private double intToValue(int value) {
            if (this.min == this.max) {
                return 0.0;
            }
            return ((double)value - this.min) / (this.max - this.min);
        }
    }
}

