/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    private static final Map<IForgeRegistry<?>, Function<? extends ForgeRegistryEntry<?>, String>> FORGE = new HashMap();

    private static <T extends ForgeRegistryEntry<T>> void registerRegistry(IForgeRegistry<T> registry, Function<T, String> mapper) {
        FORGE.put(registry, mapper);
    }

    @Nullable
    public static <T extends ForgeRegistryEntry<T>> String translate(ResourceLocation resource) {
        for (IForgeRegistry<?> registry : FORGE.keySet()) {
            if (!registry.containsKey(resource)) continue;
            return FORGE.get(registry).apply((ForgeRegistryEntry)registry.getValue(resource));
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T entry) {
        RegistryHelper.register(registry, "worldhandler", name, entry);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String modid, String name, T entry) {
        registry.register((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation(modid, name)));
    }

    static {
        RegistryHelper.registerRegistry(ForgeRegistries.BLOCKS, Block::m_7705_);
        RegistryHelper.registerRegistry(ForgeRegistries.ITEMS, Item::m_5524_);
        RegistryHelper.registerRegistry(ForgeRegistries.MOB_EFFECTS, MobEffect::m_19481_);
        RegistryHelper.registerRegistry(ForgeRegistries.BIOMES, biome -> {
            ResourceLocation resource = biome.getRegistryName();
            String key = "biome." + biome.getRegistryName().m_135827_() + "." + resource.m_135815_();
            return Language.m_128107_().m_6722_(key) ? key : resource.toString();
        });
        RegistryHelper.registerRegistry(ForgeRegistries.ENCHANTMENTS, Enchantment::m_44704_);
        RegistryHelper.registerRegistry(ForgeRegistries.ENTITIES, EntityType::m_20675_);
        RegistryHelper.registerRegistry(ForgeRegistries.STAT_TYPES, stat -> "stat." + stat.toString().replace(':', '.'));
    }
}

