/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class TextUtils {
    public static final TextComponent ARROW_LEFT = new TextComponent("<");
    public static final TextComponent ARROW_RIGHT = new TextComponent(">");
    public static final MutableComponent ARROW_LEFT_BOLD = new TextComponent("<").m_130940_(ChatFormatting.BOLD);
    public static final MutableComponent ARROW_RIGHT_BOLD = new TextComponent(">").m_130940_(ChatFormatting.BOLD);

    public static MutableComponent stripText(MutableComponent string, int maxWidth, Font font) {
        return TextUtils.stripText(string, (MutableComponent)TextComponent.f_131282_, maxWidth, font);
    }

    public static MutableComponent stripText(MutableComponent string, MutableComponent prefix, int maxWidth, Font font) {
        if (font.m_92852_((FormattedText)prefix) + font.m_92852_((FormattedText)string) > maxWidth - font.m_92852_((FormattedText)prefix)) {
            MutableComponent result = new TextComponent("").m_6270_(string.m_7383_());
            for (char c : string.getString().toCharArray()) {
                MutableComponent extension = new TextComponent(result.getString() + c + "...").m_6270_(string.m_7383_());
                if (font.m_92852_((FormattedText)extension) >= maxWidth) {
                    return new TextComponent(result.getString() + "...").m_6270_(string.m_7383_());
                }
                result = new TextComponent(result.getString() + c).m_6270_(string.m_7383_());
            }
        }
        return prefix.m_6879_().m_7220_((Component)string);
    }

    public static String formatTotalTime(long tick) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        seconds = (int)(tick / 20L);
        if (seconds > 60) {
            int min = seconds / 60;
            seconds %= 60;
            minutes = min;
        }
        if (minutes > 60) {
            int hrs = minutes / 60;
            minutes %= 60;
            hours = hrs;
        }
        if (hours > 24) {
            int day = hours / 24;
            hours %= 24;
            days = day;
        }
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static int toHour(long tick) {
        return Mth.m_14143_((float)((float)(tick + 6000L) / 1000.0f)) % 24;
    }

    public static int toMinute(long tick) {
        int hour = Mth.m_14143_((float)(((float)tick + 6000.0f) / 1000.0f));
        int minute = Mth.m_14143_((float)(((float)tick + 6000.0f - (float)(hour * 1000)) * 6.0f / 100.0f));
        return minute;
    }

    public static String formatWorldTime(long tick) {
        int hour = TextUtils.toHour(tick);
        int minute = TextUtils.toMinute(tick);
        return String.format("%02d:%02d", hour, minute);
    }

    public static MutableComponent formatNonnull(String text, Object ... parameters) {
        if (text == null) {
            return (MutableComponent)TextComponent.f_131282_;
        }
        return new TranslatableComponent(text, parameters);
    }
}

