/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class CustomizableModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<class_630.class_628> cubes;
    private final Map<String, class_630> children;

    public CustomizableModelPart(List<class_630.class_628> list, Map<String, class_630> map) {
        this.cubes = list;
        this.children = map;
    }

    public void loadPose(class_5603 partPose) {
        this.x = partPose.field_27702;
        this.y = partPose.field_27703;
        this.z = partPose.field_27704;
        this.xRot = partPose.field_27705;
        this.yRot = partPose.field_27706;
        this.zRot = partPose.field_27707;
    }

    public void copyFrom(class_630 modelPart) {
        this.xRot = modelPart.field_3654;
        this.yRot = modelPart.field_3675;
        this.zRot = modelPart.field_3674;
        this.x = modelPart.field_3657;
        this.y = modelPart.field_3656;
        this.z = modelPart.field_3655;
    }

    public class_630 getChild(String string) {
        class_630 modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (!this.visible) {
            return;
        }
        if (this.cubes.isEmpty() && this.children.isEmpty()) {
            return;
        }
        poseStack.method_22903();
        this.translateAndRotate(poseStack);
        this.compile(poseStack.method_23760(), vertexConsumer, i, j, f, g, h, k);
        for (class_630 modelPart : this.children.values()) {
            modelPart.method_22699(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
        poseStack.method_22909();
    }

    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_22904((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20707.method_23626(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20705.method_23626(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20703.method_23626(this.xRot));
        }
    }

    private void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
        for (class_630.class_628 cube : this.cubes) {
            cube.method_32089(pose, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

