/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;

public class CustomizableCube
extends ModelPart.Cube {
    private final Direction[] hidden;
    private final Polygon[] polygons;
    private int polygonCount = 0;
    public final float f_104335_;
    public final float f_104336_;
    public final float f_104337_;
    public final float f_104338_;
    public final float f_104339_;
    public final float f_104340_;

    public CustomizableCube(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Direction[] hide) {
        super(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f);
        this.hidden = hide;
        this.f_104335_ = x;
        this.f_104336_ = y;
        this.f_104337_ = z;
        this.f_104338_ = x + sizeX;
        this.f_104339_ = y + sizeY;
        this.f_104340_ = z + sizeZ;
        this.polygons = new Polygon[6];
        float pX = x + sizeX;
        float pY = y + sizeY;
        float pZ = z + sizeZ;
        x -= extraX;
        y -= extraY;
        z -= extraZ;
        pX += extraX;
        pY += extraY;
        pZ += extraZ;
        if (mirror) {
            float i = pX;
            pX = x;
            x = i;
        }
        Vertex vertex = new Vertex(x, y, z, 0.0f, 0.0f);
        Vertex vertex2 = new Vertex(pX, y, z, 0.0f, 8.0f);
        Vertex vertex3 = new Vertex(pX, pY, z, 8.0f, 8.0f);
        Vertex vertex4 = new Vertex(x, pY, z, 8.0f, 0.0f);
        Vertex vertex5 = new Vertex(x, y, pZ, 0.0f, 0.0f);
        Vertex vertex6 = new Vertex(pX, y, pZ, 0.0f, 8.0f);
        Vertex vertex7 = new Vertex(pX, pY, pZ, 8.0f, 8.0f);
        Vertex vertex8 = new Vertex(x, pY, pZ, 8.0f, 0.0f);
        float l = (float)u + sizeZ + sizeX;
        float n = (float)u + sizeZ + sizeX + sizeZ;
        float q = (float)v + sizeZ;
        float r = (float)v + sizeZ + sizeY;
        if (this.visibleFace(Direction.DOWN)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex6, vertex5, vertex, vertex2}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.DOWN);
        }
        if (this.visibleFace(Direction.UP)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex3, vertex4, vertex8, vertex7}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.UP);
        }
        if (this.visibleFace(Direction.WEST)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex, vertex5, vertex8, vertex4}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.WEST);
        }
        if (this.visibleFace(Direction.NORTH)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex2, vertex, vertex4, vertex3}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.NORTH);
        }
        if (this.visibleFace(Direction.EAST)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex6, vertex2, vertex3, vertex7}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.EAST);
        }
        if (this.visibleFace(Direction.SOUTH)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex5, vertex6, vertex7, vertex8}, l, q, n, r, textureWidth, textureHeight, mirror, Direction.SOUTH);
        }
    }

    private boolean visibleFace(Direction face) {
        for (Direction dir : this.hidden) {
            if (dir != face) continue;
            return false;
        }
        return true;
    }

    public void m_171332_(PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        for (int id = 0; id < this.polygonCount; ++id) {
            Polygon polygon = this.polygons[id];
            Vector3f vector3f = polygon.normal.m_122281_();
            vector3f.m_122249_(matrix3f);
            float l = vector3f.m_122239_();
            float m = vector3f.m_122260_();
            float n = vector3f.m_122269_();
            for (int i = 0; i < 4; ++i) {
                Vertex vertex = polygon.vertices[i];
                Vector4f vector4f = new Vector4f(vertex.o, vertex.p, vertex.q, 1.0f);
                vector4f.m_123607_(matrix4f);
                vertexConsumer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, l, m, n);
            }
        }
    }

    private static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] vertexs, float f, float g, float h, float i, float j, float k, boolean bl, Direction direction) {
            this.vertices = vertexs;
            float l = 0.0f / j;
            float m = 0.0f / k;
            vertexs[0] = vertexs[0].remap(h / j - l, g / k + m);
            vertexs[1] = vertexs[1].remap(f / j + l, g / k + m);
            vertexs[2] = vertexs[2].remap(f / j + l, i / k - m);
            vertexs[3] = vertexs[3].remap(h / j - l, i / k - m);
            if (bl) {
                int n = vertexs.length;
                for (int o = 0; o < n / 2; ++o) {
                    Vertex vertex = vertexs[o];
                    vertexs[o] = vertexs[n - 1 - o];
                    vertexs[n - 1 - o] = vertex;
                }
            }
            this.normal = direction.m_122432_();
            if (bl) {
                this.normal.m_122263_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;
        public final float o;
        public final float p;
        public final float q;

        public Vertex(float f, float g, float h, float i, float j) {
            this(new Vector3f(f, g, h), i, j);
        }

        public Vertex remap(float f, float g) {
            return new Vertex(this.pos, f, g);
        }

        public Vertex(Vector3f vector3f, float f, float g) {
            this.pos = vector3f;
            this.u = f;
            this.v = g;
            this.o = this.pos.m_122239_() / 16.0f;
            this.p = this.pos.m_122260_() / 16.0f;
            this.q = this.pos.m_122269_() / 16.0f;
        }
    }
}

