/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class CustomizableModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<ModelPart.Cube> cubes;
    private final Map<String, ModelPart> children;

    public CustomizableModelPart(List<ModelPart.Cube> list, Map<String, ModelPart> map) {
        this.cubes = list;
        this.children = map;
    }

    public void loadPose(PartPose partPose) {
        this.x = partPose.f_171405_;
        this.y = partPose.f_171406_;
        this.z = partPose.f_171407_;
        this.xRot = partPose.f_171408_;
        this.yRot = partPose.f_171409_;
        this.zRot = partPose.f_171410_;
    }

    public void copyFrom(ModelPart modelPart) {
        this.xRot = modelPart.f_104203_;
        this.yRot = modelPart.f_104204_;
        this.zRot = modelPart.f_104205_;
        this.x = modelPart.f_104200_;
        this.y = modelPart.f_104201_;
        this.z = modelPart.f_104202_;
    }

    public ModelPart getChild(String string) {
        ModelPart modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (!this.visible) {
            return;
        }
        if (this.cubes.isEmpty() && this.children.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        this.translateAndRotate(poseStack);
        this.compile(poseStack.m_85850_(), vertexConsumer, i, j, f, g, h, k);
        for (ModelPart modelPart : this.children.values()) {
            modelPart.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
        poseStack.m_85849_();
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        for (ModelPart.Cube cube : this.cubes) {
            cube.m_171332_(pose, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

