/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class BodyLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.m_117386_()).hasThinArms();
    private static final Minecraft mc = Minecraft.m_91087_();

    public BodyLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (!player.m_108559_() || player.m_20145_()) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.f_91074_.m_20280_((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (settings.getSkinLayers() == null && !this.setupModel(player, settings)) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)player.m_108560_()));
        int m = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings.getSkinLayers(), poseStack, vertexConsumer, i, m);
    }

    private boolean setupModel(AbstractClientPlayer abstractClientPlayerEntity, PlayerSettings settings) {
        if (!SkinUtil.hasCustomSkin(abstractClientPlayerEntity)) {
            return false;
        }
        NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        CustomizableModelPart[] layers = new CustomizableModelPart[5];
        layers[0] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 4, 12, 4, 0, 48, true, 0.0f);
        layers[1] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 4, 12, 4, 0, 32, true, 0.0f);
        if (this.thinArms) {
            layers[2] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 3, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 3, 12, 4, 40, 32, true, -2.5f);
        } else {
            layers[2] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 4, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 4, 12, 4, 40, 32, true, -2.5f);
        }
        layers[4] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()), 8, 12, 4, 16, 32, true, -0.8f);
        settings.setupSkinLayers(layers);
        skin.m_85123_();
        return true;
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, CustomizableModelPart[] layers, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        float color;
        if (layers == null) {
            return;
        }
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = SkinLayersModBase.config.bodyVoxelHeightSize;
        CustomizableModelPart leftLeg = layers[0];
        CustomizableModelPart rightLeg = layers[1];
        CustomizableModelPart leftArm = layers[2];
        CustomizableModelPart rightArm = layers[3];
        CustomizableModelPart jacket = layers[4];
        boolean red = abstractClientPlayer.f_20916_ > 0 || abstractClientPlayer.f_20919_ > 0;
        float f = color = red ? 0.5f : 1.0f;
        if (abstractClientPlayer.m_36170_(PlayerModelPart.LEFT_PANTS_LEG) && ((PlayerModel)this.m_117386_()).f_102814_.f_104207_ && SkinLayersModBase.config.enableLeftPants) {
            matrixStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102814_.m_104299_(matrixStack);
            matrixStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            leftLeg.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
        if (abstractClientPlayer.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG) && ((PlayerModel)this.m_117386_()).f_102813_.f_104207_ && SkinLayersModBase.config.enableRightPants) {
            matrixStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102813_.m_104299_(matrixStack);
            matrixStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            rightLeg.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
        if (abstractClientPlayer.m_36170_(PlayerModelPart.LEFT_SLEEVE) && ((PlayerModel)this.m_117386_()).f_102812_.f_104207_ && SkinLayersModBase.config.enableLeftSleeve) {
            matrixStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102812_.m_104299_(matrixStack);
            leftArm.x = this.thinArms ? 0.6f : 1.0f;
            matrixStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            leftArm.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
        if (abstractClientPlayer.m_36170_(PlayerModelPart.RIGHT_SLEEVE) && ((PlayerModel)this.m_117386_()).f_102811_.f_104207_ && SkinLayersModBase.config.enableRightSleeve) {
            matrixStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102811_.m_104299_(matrixStack);
            rightArm.x = this.thinArms ? -0.6f : -1.0f;
            matrixStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            rightArm.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
        if (abstractClientPlayer.m_36170_(PlayerModelPart.JACKET) && ((PlayerModel)this.m_117386_()).f_102810_.f_104207_ && SkinLayersModBase.config.enableJacket) {
            matrixStack.m_85836_();
            jacket.copyFrom(((PlayerModel)this.m_117386_()).f_103378_);
            matrixStack.m_85841_(pixelScaling, heightScaling, pixelScaling);
            if (abstractClientPlayer.m_6047_()) {
                matrixStack.m_85837_(0.0, 0.0, (double)-0.025f);
            }
            jacket.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
    }
}

