/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class CustomizableCube
extends class_630.class_628 {
    private final class_2350[] hidden;
    private final Polygon[] polygons;
    private int polygonCount = 0;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public CustomizableCube(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, class_2350[] hide) {
        super(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f);
        this.hidden = hide;
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + sizeX;
        this.maxY = y + sizeY;
        this.maxZ = z + sizeZ;
        this.polygons = new Polygon[6];
        float pX = x + sizeX;
        float pY = y + sizeY;
        float pZ = z + sizeZ;
        x -= extraX;
        y -= extraY;
        z -= extraZ;
        pX += extraX;
        pY += extraY;
        pZ += extraZ;
        if (mirror) {
            float i = pX;
            pX = x;
            x = i;
        }
        Vertex vertex = new Vertex(x, y, z, 0.0f, 0.0f);
        Vertex vertex2 = new Vertex(pX, y, z, 0.0f, 8.0f);
        Vertex vertex3 = new Vertex(pX, pY, z, 8.0f, 8.0f);
        Vertex vertex4 = new Vertex(x, pY, z, 8.0f, 0.0f);
        Vertex vertex5 = new Vertex(x, y, pZ, 0.0f, 0.0f);
        Vertex vertex6 = new Vertex(pX, y, pZ, 0.0f, 8.0f);
        Vertex vertex7 = new Vertex(pX, pY, pZ, 8.0f, 8.0f);
        Vertex vertex8 = new Vertex(x, pY, pZ, 8.0f, 0.0f);
        float l = (float)u + sizeZ + sizeX;
        float n = (float)u + sizeZ + sizeX + sizeZ;
        float q = (float)v + sizeZ;
        float r = (float)v + sizeZ + sizeY;
        if (this.visibleFace(class_2350.field_11033)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex6, vertex5, vertex, vertex2}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11033);
        }
        if (this.visibleFace(class_2350.field_11036)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex3, vertex4, vertex8, vertex7}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11036);
        }
        if (this.visibleFace(class_2350.field_11039)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex, vertex5, vertex8, vertex4}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11039);
        }
        if (this.visibleFace(class_2350.field_11043)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex2, vertex, vertex4, vertex3}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11043);
        }
        if (this.visibleFace(class_2350.field_11034)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex6, vertex2, vertex3, vertex7}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11034);
        }
        if (this.visibleFace(class_2350.field_11035)) {
            this.polygons[this.polygonCount++] = new Polygon(new Vertex[]{vertex5, vertex6, vertex7, vertex8}, l, q, n, r, textureWidth, textureHeight, mirror, class_2350.field_11035);
        }
    }

    private boolean visibleFace(class_2350 face) {
        for (class_2350 dir : this.hidden) {
            if (dir != face) continue;
            return false;
        }
        return true;
    }

    public void render(class_4587.class_4665 pose, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        class_1159 matrix4f = pose.method_23761();
        class_4581 matrix3f = pose.method_23762();
        for (int id = 0; id < this.polygonCount; ++id) {
            Polygon polygon = this.polygons[id];
            class_1160 vector3f = polygon.normal.method_23850();
            vector3f.method_23215(matrix3f);
            float l = vector3f.method_4943();
            float m = vector3f.method_4945();
            float n = vector3f.method_4947();
            for (int i = 0; i < 4; ++i) {
                Vertex vertex = polygon.vertices[i];
                class_1162 vector4f = new class_1162(vertex.o, vertex.p, vertex.q, 1.0f);
                vector4f.method_22674(matrix4f);
                vertexConsumer.method_23919(vector4f.method_4953(), vector4f.method_4956(), vector4f.method_4957(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, l, m, n);
            }
        }
    }

    private static class Vertex {
        public final class_1160 pos;
        public final float u;
        public final float v;
        public final float o;
        public final float p;
        public final float q;

        public Vertex(float f, float g, float h, float i, float j) {
            this(new class_1160(f, g, h), i, j);
        }

        public Vertex remap(float f, float g) {
            return new Vertex(this.pos, f, g);
        }

        public Vertex(class_1160 vector3f, float f, float g) {
            this.pos = vector3f;
            this.u = f;
            this.v = g;
            this.o = this.pos.method_4943() / 16.0f;
            this.p = this.pos.method_4945() / 16.0f;
            this.q = this.pos.method_4947() / 16.0f;
        }
    }

    private static class Polygon {
        public final Vertex[] vertices;
        public final class_1160 normal;

        public Polygon(Vertex[] vertexs, float f, float g, float h, float i, float j, float k, boolean bl, class_2350 direction) {
            this.vertices = vertexs;
            float l = 0.0f / j;
            float m = 0.0f / k;
            vertexs[0] = vertexs[0].remap(h / j - l, g / k + m);
            vertexs[1] = vertexs[1].remap(f / j + l, g / k + m);
            vertexs[2] = vertexs[2].remap(f / j + l, i / k - m);
            vertexs[3] = vertexs[3].remap(h / j - l, i / k - m);
            if (bl) {
                int n = vertexs.length;
                for (int o = 0; o < n / 2; ++o) {
                    Vertex vertex = vertexs[o];
                    vertexs[o] = vertexs[n - 1 - o];
                    vertexs[n - 1 - o] = vertex;
                }
            }
            this.normal = direction.method_23955();
            if (bl) {
                this.normal.method_23849(-1.0f, 1.0f, 1.0f);
            }
        }
    }
}

