/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;

public class CustomizableModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<CustomizableCube> cubes;
    private final Map<String, ModelRenderer> children;

    public CustomizableModelPart(List<CustomizableCube> list, Map<String, ModelRenderer> map) {
        this.cubes = list;
        this.children = map;
    }

    public void copyFrom(ModelRenderer modelPart) {
        this.xRot = modelPart.field_78795_f;
        this.yRot = modelPart.field_78796_g;
        this.zRot = modelPart.field_78808_h;
        this.x = modelPart.field_78800_c;
        this.y = modelPart.field_78797_d;
        this.z = modelPart.field_78798_e;
    }

    public ModelRenderer getChild(String string) {
        ModelRenderer modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void render(MatrixStack poseStack, IVertexBuilder vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(MatrixStack poseStack, IVertexBuilder vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (!this.visible) {
            return;
        }
        if (this.cubes.isEmpty() && this.children.isEmpty()) {
            return;
        }
        poseStack.func_227860_a_();
        this.translateAndRotate(poseStack);
        this.compile(poseStack.func_227866_c_(), vertexConsumer, i, j, f, g, h, k);
        for (ModelRenderer modelPart : this.children.values()) {
            modelPart.func_228309_a_(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
        poseStack.func_227865_b_();
    }

    public void translateAndRotate(MatrixStack poseStack) {
        poseStack.func_227861_a_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.xRot));
        }
    }

    private void compile(MatrixStack.Entry pose, IVertexBuilder vertexConsumer, int i, int j, float f, float g, float h, float k) {
        for (CustomizableCube cube : this.cubes) {
            cube.render(pose, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

