/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;

public class BodyLayerFeatureRenderer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.func_215332_c()).hasThinArms();
    private static final Minecraft mc = Minecraft.func_71410_x();

    public BodyLayerFeatureRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int i, AbstractClientPlayerEntity player, float f, float g, float h, float j, float k, float l) {
        if (!player.func_152123_o() || player.func_82150_aj()) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.field_71439_g.func_70068_e((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (settings.getSkinLayers() == null && !this.setupModel(player, settings)) {
            return;
        }
        IVertexBuilder vertexConsumer = multiBufferSource.getBuffer(RenderType.func_228642_d_((ResourceLocation)player.func_110306_p()));
        int m = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings.getSkinLayers(), poseStack, vertexConsumer, i, m);
    }

    private boolean setupModel(AbstractClientPlayerEntity abstractClientPlayerEntity, PlayerSettings settings) {
        if (!SkinUtil.hasCustomSkin(abstractClientPlayerEntity)) {
            return false;
        }
        NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        CustomizableModelPart[] layers = new CustomizableModelPart[5];
        layers[0] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 4, 12, 4, 0, 48, true, 0.0f);
        layers[1] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 4, 12, 4, 0, 32, true, 0.0f);
        if (this.thinArms) {
            layers[2] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 3, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 3, 12, 4, 40, 32, true, -2.5f);
        } else {
            layers[2] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 4, 12, 4, 48, 48, true, -2.5f);
            layers[3] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 4, 12, 4, 40, 32, true, -2.5f);
        }
        layers[4] = SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 8, 12, 4, 16, 32, true, -0.8f);
        settings.setupSkinLayers(layers);
        skin.func_195711_f();
        return true;
    }

    public void renderLayers(AbstractClientPlayerEntity abstractClientPlayer, CustomizableModelPart[] layers, MatrixStack matrixStack, IVertexBuilder vertices, int light, int overlay) {
        float color;
        if (layers == null) {
            return;
        }
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = SkinLayersModBase.config.bodyVoxelHeightSize;
        CustomizableModelPart leftLeg = layers[0];
        CustomizableModelPart rightLeg = layers[1];
        CustomizableModelPart leftArm = layers[2];
        CustomizableModelPart rightArm = layers[3];
        CustomizableModelPart jacket = layers[4];
        boolean red = abstractClientPlayer.field_70737_aN > 0 || abstractClientPlayer.field_70725_aQ > 0;
        float f = color = red ? 0.5f : 1.0f;
        if (abstractClientPlayer.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG) && ((PlayerModel)this.func_215332_c()).field_178722_k.field_78806_j && SkinLayersModBase.config.enableLeftPants) {
            matrixStack.func_227860_a_();
            ((PlayerModel)this.func_215332_c()).field_178722_k.func_228307_a_(matrixStack);
            matrixStack.func_227862_a_(pixelScaling, heightScaling, pixelScaling);
            leftLeg.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.func_227865_b_();
        }
        if (abstractClientPlayer.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG) && ((PlayerModel)this.func_215332_c()).field_178721_j.field_78806_j && SkinLayersModBase.config.enableRightPants) {
            matrixStack.func_227860_a_();
            ((PlayerModel)this.func_215332_c()).field_178721_j.func_228307_a_(matrixStack);
            matrixStack.func_227862_a_(pixelScaling, heightScaling, pixelScaling);
            rightLeg.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.func_227865_b_();
        }
        if (abstractClientPlayer.func_175148_a(PlayerModelPart.LEFT_SLEEVE) && ((PlayerModel)this.func_215332_c()).field_178724_i.field_78806_j && SkinLayersModBase.config.enableLeftSleeve) {
            matrixStack.func_227860_a_();
            ((PlayerModel)this.func_215332_c()).field_178724_i.func_228307_a_(matrixStack);
            leftArm.x = this.thinArms ? 0.6f : 1.0f;
            matrixStack.func_227862_a_(pixelScaling, heightScaling, pixelScaling);
            leftArm.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.func_227865_b_();
        }
        if (abstractClientPlayer.func_175148_a(PlayerModelPart.RIGHT_SLEEVE) && ((PlayerModel)this.func_215332_c()).field_178723_h.field_78806_j && SkinLayersModBase.config.enableRightSleeve) {
            matrixStack.func_227860_a_();
            ((PlayerModel)this.func_215332_c()).field_178723_h.func_228307_a_(matrixStack);
            rightArm.x = this.thinArms ? -0.6f : -1.0f;
            matrixStack.func_227862_a_(pixelScaling, heightScaling, pixelScaling);
            rightArm.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.func_227865_b_();
        }
        if (abstractClientPlayer.func_175148_a(PlayerModelPart.JACKET) && ((PlayerModel)this.func_215332_c()).field_78115_e.field_78806_j && SkinLayersModBase.config.enableJacket) {
            matrixStack.func_227860_a_();
            jacket.copyFrom(((PlayerModel)this.func_215332_c()).field_178730_v);
            matrixStack.func_227862_a_(pixelScaling, heightScaling, pixelScaling);
            if (abstractClientPlayer.func_213453_ef()) {
                matrixStack.func_227861_a_(0.0, 0.0, (double)-0.025f);
            }
            jacket.render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.func_227865_b_();
        }
    }
}

