/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.blocks.Pedestal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;

public abstract class FireBase
extends ModBlock {
    public static BooleanProperty SET = BooleanProperty.m_61465_((String)"set");
    public static BooleanProperty SUMMONED = BooleanProperty.m_61465_((String)"summoned");
    public static BooleanProperty TEMP = BooleanProperty.m_61465_((String)"temp");
    private static Map<PedestalTypes, VoxelShape> SHAPES;
    private static Map<PedestalTypes, SimpleParticleType> PARTICLE_TYPES;
    private static Map<PedestalTypes, Double> SMOKE_POS;
    private static final VoxelShape COLLISION_SHAPE;
    private PedestalTypes pedestalKey;

    protected static BlockBehaviour.Properties createProps(MaterialColor mapColor) {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)mapColor).m_60966_().m_60910_().m_60918_((SoundType)new ForgeSoundType(1.5f, 1.0f, () -> AdditionalLights.modSounds.get((Object)ModSoundList.Fire_Extinguish), () -> SoundEvents.f_12591_, () -> SoundEvents.f_12447_, () -> SoundEvents.f_12641_, () -> SoundEvents.f_12640_));
    }

    protected FireBase(String basename, PedestalTypes _pedestalKey, BlockBehaviour.Properties props) {
        super(basename + _pedestalKey, null, props, SHAPES.get((Object)_pedestalKey));
        this.pedestalKey = _pedestalKey;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SUMMONED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TEMP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SET});
        builder.m_61104_(new Property[]{SUMMONED});
        builder.m_61104_(new Property[]{TEMP});
    }

    protected float getFireDamageAmount() {
        return 0.0f;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockgetter, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public void setRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockgetter, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.pedestalKey);
    }

    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + SMOKE_POS.get((Object)this.pedestalKey);
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_7106_((ParticleOptions)PARTICLE_TYPES.get((Object)this.pedestalKey), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.isValidPosition(stateIn, level, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public boolean isValidPosition(BlockState state, LevelAccessor level, BlockPos pos) {
        return !level.m_46859_(pos.m_7495_()) && level.m_8055_(pos.m_7495_()).m_60767_() != Material.f_76305_;
    }

    @Override
    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        if (state.m_61143_((Property)SUMMONED) == Boolean.FALSE && state.m_61143_((Property)TEMP) == Boolean.FALSE) {
            return super.m_7381_((BlockState)state.m_61124_((Property)SET, (Comparable)Boolean.valueOf(false)), builder);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        return list;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Block lowerblock = level.m_8055_(pos.m_7495_()).m_60734_();
        if (lowerblock instanceof Pedestal != Boolean.TRUE) {
            return;
        }
        Pedestal pedestal = (Pedestal)lowerblock;
        if (pedestal.getType() == this.pedestalKey) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SET, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter blockgetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
        SHAPES = new LinkedHashMap<PedestalTypes, VoxelShape>();
        SHAPES.put(PedestalTypes.standing_torch_s, Block.m_49796_((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
        SHAPES.put(PedestalTypes.standing_torch_l, Block.m_49796_((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
        SHAPES.put(PedestalTypes.fire_pit_s, Block.m_49796_((double)0.0, (double)-10.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        SHAPES.put(PedestalTypes.fire_pit_l, Block.m_49796_((double)0.0, (double)-2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
        PARTICLE_TYPES = new LinkedHashMap<PedestalTypes, SimpleParticleType>();
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_s, ParticleTypes.f_123762_);
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_l, ParticleTypes.f_123762_);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_s, ParticleTypes.f_123755_);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_l, ParticleTypes.f_123755_);
        SMOKE_POS = new LinkedHashMap<PedestalTypes, Double>();
        SMOKE_POS.put(PedestalTypes.standing_torch_s, 0.2);
        SMOKE_POS.put(PedestalTypes.standing_torch_l, 0.7);
        SMOKE_POS.put(PedestalTypes.fire_pit_s, 0.0);
        SMOKE_POS.put(PedestalTypes.fire_pit_l, 0.8);
    }
}

