/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.items;

import com.mgen256.al.FireTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.Pedestal;
import com.mgen256.al.items.Wand;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class SoulWand
extends Wand {
    private static Item.Properties createProps() {
        Item.Properties p = new Item.Properties();
        p.setNoRepair();
        p.m_41487_(1);
        p.m_41499_(1);
        return p;
    }

    public SoulWand() {
        super(SoulWand.createProps());
        this.setRegistryName("soul_wand");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand handIn) {
        BlockPos underPos;
        Block underBlock;
        ItemStack stack = player.m_21120_(handIn);
        BlockHitResult hitresult = SoulWand.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = hitresult.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IHasFire) {
            this.changeFire(level, player, pos, state, (IHasFire)block);
        } else if (block instanceof FireBase && (underBlock = level.m_8055_(underPos = pos.m_7495_()).m_60734_()) instanceof IHasFire) {
            this.changeFire(level, player, underPos, level.m_8055_(underPos), (IHasFire)underBlock);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private void changeFire(Level level, Player player, BlockPos pos, BlockState state, IHasFire modblock) {
        FireTypes currentType = (FireTypes)((Object)state.m_61143_(IHasFire.FIRE_TYPE));
        FireTypes prevType = (FireTypes)((Object)state.m_61143_(IHasFire.PREVIOUS_FIRE_TYPE));
        if (prevType == FireTypes.SOUL) {
            prevType = FireTypes.NORMAL;
        }
        if (player.m_5791_()) {
            if (currentType == FireTypes.SOUL) {
                state = modblock.setFireType(level, pos, state, prevType, prevType);
                this.playSound(level, player, Wand.SoundEvents.UNDO, 0.6f);
            }
        } else if (currentType != FireTypes.SOUL) {
            state = modblock.setFireType(level, pos, state, FireTypes.SOUL, prevType);
            this.playSound(level, player, Wand.SoundEvents.CHANGE, 0.8f);
        }
        if (modblock instanceof Pedestal) {
            ((Pedestal)modblock).setFire(level, pos, state, true);
        }
    }
}

