/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.FirePitBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.items.SoulWand;
import com.mgen256.al.items.Wand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class Pedestal
extends ModBlock
implements SimpleWaterloggedBlock,
IHasFire {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ACCEPT_POWER = BooleanProperty.m_61465_((String)"accept_power");
    public static final BooleanProperty ISPOWERED = BooleanProperty.m_61465_((String)"ispowered");
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    private static Component txt_shift;
    private static Component txt_tips;
    private static Component txt_rightclick;
    private static Component txt_sneaking;
    private static Component txt_signals;
    protected SIZE size;
    private static SoundEvent ignitionSound;

    private static BlockBehaviour.Properties createProps(Block mainblock) {
        BlockState mainblockState = mainblock.m_49966_();
        Material mbm = mainblockState.m_60767_();
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60944_((Material)mbm, (MaterialColor)mainblockState.m_60780_(null, null)).m_155954_(mainblockState.m_60800_(null, null)).m_155956_(mainblockState.getExplosionResistance(null, null, null)).m_60918_(mainblockState.getSoundType(null, null, null));
        if (mainblockState.m_60834_()) {
            return prop.m_60999_();
        }
        return prop;
    }

    protected Pedestal(Block mainblock, VoxelShape shape, SIZE size) {
        super(mainblock, Pedestal.createProps(mainblock), shape);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).m_61124_((Property)PREVIOUS_FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).m_61124_((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
        if (ignitionSound == null) {
            ignitionSound = size == SIZE.L ? AdditionalLights.getSound(ModSoundList.Fire_Ignition_L) : AdditionalLights.getSound(ModSoundList.Fire_Ignition_S);
        }
    }

    protected abstract ModBlockList getFireKey(BlockState var1);

    public abstract PedestalTypes getType();

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{FIRE_TYPE});
        builder.m_61104_(new Property[]{PREVIOUS_FIRE_TYPE});
        builder.m_61104_(new Property[]{ACCEPT_POWER});
        builder.m_61104_(new Property[]{ISPOWERED});
        builder.m_61104_(new Property[]{ACTIVATED});
    }

    public boolean m_6044_(BlockGetter blockgetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61143_((Property)BlockStateProperties.f_61362_) == Boolean.TRUE ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private Block getFireBlock(BlockState state) {
        return AdditionalLights.getBlock(this.getFireKey(state));
    }

    public boolean setFire(Level level, BlockPos pos, BlockState state, boolean replaceOnly) {
        BlockPos upperpos = pos.m_7494_();
        BlockState upperBlockState = level.m_8055_(upperpos);
        Block upperblock = upperBlockState.m_60734_();
        FireBase firebase = null;
        if (upperblock instanceof FireBase) {
            firebase = (FireBase)upperblock;
        }
        if (replaceOnly ? firebase == null : !(upperBlockState.m_60795_() || upperBlockState.m_60767_() == Material.f_76305_ || firebase != null)) {
            return false;
        }
        if (firebase != null && !((Boolean)level.m_8055_(upperpos).m_61143_((Property)FireBase.SUMMONED)).booleanValue()) {
            level.m_46961_(upperpos, true);
        }
        return level.m_46597_(upperpos, (BlockState)((BlockState)this.getFireBlock(state).m_49966_().m_61124_((Property)FireBase.SET, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FireBase.SUMMONED, (Comparable)Boolean.valueOf(true)));
    }

    public void removeFire(Level level, BlockPos pos, BlockState state) {
        if (!(level.m_8055_(pos.m_7494_()).m_60734_() instanceof FireBase)) {
            return;
        }
        level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (handIn == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() instanceof Wand) {
            return InteractionResult.FAIL;
        }
        if (!this.setFire(level, pos, state, false)) {
            return InteractionResult.PASS;
        }
        Pedestal.playIgnitionSound(level, player, state.m_60734_(), pos);
        return InteractionResult.SUCCESS;
    }

    private static void playIgnitionSound(Level level, Player player, Block block, BlockPos pos) {
        float volume = block instanceof FirePitBase ? 2.0f : 1.5f;
        level.m_5594_(player, pos, ignitionSound, SoundSource.BLOCKS, volume, 1.0f);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            return;
        }
        if (placer.m_21206_().m_41720_() instanceof SoulWand) {
            state = (BlockState)state.m_61124_((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.SOUL));
        }
        if (placer.m_5791_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(false)));
        } else {
            level.m_46597_(pos, state);
            this.setFire(level, pos, state, false);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        state = level.m_8055_(pos);
        if (state.m_61143_((Property)ACCEPT_POWER) != Boolean.TRUE) {
            return;
        }
        if (level.m_46753_(pos)) {
            if (state.m_61143_((Property)ACTIVATED) == Boolean.TRUE) {
                return;
            }
            if (this.setFire(level, pos, state, false)) {
                Pedestal.playIgnitionSound(level, null, state.m_60734_(), pos);
            }
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ISPOWERED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.m_61143_((Property)ISPOWERED)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            this.removeFire(level, pos, state);
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockgetter, List<Component> tooltip, TooltipFlag flagIn) {
        if (txt_shift == null) {
            if (I18n.m_118936_((String)"additional_lights.txt.shift") != Boolean.TRUE) {
                return;
            }
            txt_shift = Component.m_237115_((String)"additional_lights.txt.shift");
            txt_tips = Component.m_237115_((String)"additional_lights.txt.tips");
            txt_rightclick = Component.m_237115_((String)"additional_lights.txt.block.pedestal.rightclick");
            txt_sneaking = Component.m_237115_((String)"additional_lights.txt.block.pedestal.sneaking");
            txt_signals = Component.m_237115_((String)"additional_lights.txt.block.pedestal.signals");
        }
        if (Screen.m_96638_()) {
            tooltip.add(txt_tips);
            tooltip.add(txt_rightclick);
            tooltip.add(txt_sneaking);
            tooltip.add(txt_signals);
        } else {
            tooltip.add(txt_shift);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter blockgetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    static enum SIZE {
        S,
        L;

    }
}

