/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.fontLibrary;

import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 62\u00020\u0001:\u000256B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\u0016\u0010\u001a\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJH\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0002J.\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\b\b\u0002\u00102\u001a\u00020*J\u0016\u00103\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u000e\u00104\u001a\u00020\r2\u0006\u00102\u001a\u00020*R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont;", "", "font", "Ljava/awt/Font;", "antiAlias", "", "alphabet", "", "", "(Ljava/awt/Font;ZLjava/util/Set;)V", "fontMetrics", "Ljava/awt/FontMetrics;", "fontTextureID", "", "glyphs", "", "Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont$CharacterGlyph;", "<set-?>", "height", "getHeight", "()I", "textureHeight", "textureWidth", "calcGuiScale", "", "computeFontMetrics", "createTextureSheet", "destroy", "", "drawQuad", "drawX", "drawY", "drawX2", "drawY2", "srcX", "srcY", "srcX2", "srcY2", "drawString", "x", "y", "stringToDraw", "", "textAlignment", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/TextAlignment;", "rgba", "Ljava/awt/Color;", "getFontImage", "Ljava/awt/image/BufferedImage;", "character", "string", "getTextureSize", "getWidth", "CharacterGlyph", "Companion", "afraidofthedark"})
public final class TrueTypeFont {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Font font;
    private final boolean antiAlias;
    @NotNull
    private final Map<Character, CharacterGlyph> glyphs;
    private int height;
    private final int fontTextureID;
    private final int textureWidth;
    private final int textureHeight;
    @NotNull
    private final FontMetrics fontMetrics;
    private static final Logger logger;
    private static final char DEFAULT_CHARACTER = '?';
    @NotNull
    private static final List<Integer> validTextureSizes;

    public TrueTypeFont(@NotNull Font font, boolean antiAlias, @NotNull Set<Character> alphabet) {
        int textureWidthHeight;
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter(alphabet, "alphabet");
        this.font = font;
        this.antiAlias = antiAlias;
        boolean bl = false;
        this.glyphs = new LinkedHashMap();
        Set<Character> supportedAlphabet = SetsKt.plus(alphabet, Character.valueOf('?'));
        this.fontMetrics = this.computeFontMetrics();
        this.textureWidth = textureWidthHeight = this.getTextureSize(supportedAlphabet);
        this.textureHeight = textureWidthHeight;
        this.fontTextureID = this.createTextureSheet(supportedAlphabet);
    }

    public final int getHeight() {
        return this.height;
    }

    private final FontMetrics computeFontMetrics() {
        Object object = new BufferedImage(1, 1, 2).getGraphics();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)object;
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        object = g.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue(object, "g.fontMetrics");
        return object;
    }

    private final int getTextureSize(Set<Character> alphabet) {
        int maxCharHeight = this.fontMetrics.getHeight();
        List indexableAlphabet = CollectionsKt.toList((Iterable)alphabet);
        Iterator<Integer> iterator2 = validTextureSizes.iterator();
        while (iterator2.hasNext()) {
            int possibleTextureSize = ((Number)iterator2.next()).intValue();
            int rowsRemaining = possibleTextureSize / maxCharHeight;
            double currentRowLength = 0.0;
            int currentCharIndex = 0;
            while (rowsRemaining > 0) {
                int n;
                if (currentCharIndex >= indexableAlphabet.size()) {
                    return possibleTextureSize;
                }
                int currentCharWidth = this.fontMetrics.charWidth(((Character)indexableAlphabet.get(currentCharIndex)).charValue());
                if (currentRowLength + (double)currentCharWidth > (double)possibleTextureSize) {
                    currentRowLength = 0.0;
                    n = rowsRemaining;
                    rowsRemaining = n + -1;
                    continue;
                }
                currentRowLength += (double)currentCharWidth;
                n = currentCharIndex;
                currentCharIndex = n + 1;
            }
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus("Texture width/height could not be created as it would be larger than ", CollectionsKt.maxOrNull((Iterable)validTextureSizes)));
    }

    private final int createTextureSheet(Set<Character> alphabet) {
        BufferedImage imgTemp = new BufferedImage(this.textureWidth, this.textureHeight, 2);
        Graphics graphics = imgTemp.getGraphics();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, this.textureWidth, this.textureHeight);
        int rowHeight = 0;
        int positionX = 0;
        int positionY = 0;
        for (char character : alphabet) {
            BufferedImage fontImage = this.getFontImage(character);
            CharacterGlyph characterGlyph = new CharacterGlyph(0, 0, 0, 0, 15, null);
            characterGlyph.setWidth(fontImage.getWidth());
            characterGlyph.setHeight(fontImage.getHeight());
            if (positionX + characterGlyph.getWidth() >= this.textureWidth) {
                positionX = 0;
                positionY += rowHeight;
                rowHeight = 0;
            }
            characterGlyph.setStoredX(positionX);
            characterGlyph.setStoredY(positionY);
            int n = this.height;
            int n2 = characterGlyph.getHeight();
            boolean bl = false;
            this.height = Math.max(n, n2);
            n = characterGlyph.getHeight();
            n2 = 0;
            rowHeight = Math.max(rowHeight, n);
            g.drawImage((Image)fontImage, positionX, positionY, null);
            positionX += characterGlyph.getWidth();
            Map<Character, CharacterGlyph> map = this.glyphs;
            Character c = Character.valueOf(character);
            bl = false;
            map.put(c, characterGlyph);
        }
        return TrueTypeFont.Companion.loadImage(imgTemp);
    }

    private final BufferedImage getFontImage(char character) {
        BufferedImage fontImage;
        Graphics graphics;
        int charWidth = this.fontMetrics.charWidth(character);
        charWidth = RangesKt.coerceAtLeast(charWidth, 1);
        int charHeight = this.fontMetrics.getHeight();
        if (charHeight <= 0) {
            charHeight = this.font.getSize();
        }
        if ((graphics = (fontImage = new BufferedImage(charWidth, charHeight, 2)).getGraphics()) == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        g.drawString(String.valueOf(character), 0, this.fontMetrics.getAscent());
        return fontImage;
    }

    private final float calcGuiScale() {
        Minecraft minecraft = Minecraft.func_71410_x();
        int n = minecraft.field_195558_d.func_198105_m();
        int n2 = minecraft.field_195558_d.func_198083_n();
        boolean bl = false;
        int min = Math.min(n, n2);
        float refSize = 480.0f;
        return 0.4f * (float)min / refSize / (float)minecraft.field_195558_d.func_216521_a(minecraft.field_71474_y.field_74335_Z, minecraft.func_211821_e());
    }

    public final void drawString(float x, float y, @NotNull String stringToDraw, @NotNull TextAlignment textAlignment, @NotNull Color rgba) {
        int n;
        String[] stringArray;
        Intrinsics.checkNotNullParameter(stringToDraw, "stringToDraw");
        Intrinsics.checkNotNullParameter((Object)textAlignment, "textAlignment");
        Intrinsics.checkNotNullParameter(rgba, "rgba");
        CharacterGlyph characterGlyph = null;
        int totalWidth = 0;
        int drawX = 0;
        int drawY = 0;
        float guiScale = this.calcGuiScale();
        String[] stringArray2 = new String[]{"\n"};
        for (String[] line : StringsKt.split$default((CharSequence)stringToDraw, stringArray2, false, 0, 6, null)) {
            int lineLen = 0;
            stringArray = line;
            int n2 = 0;
            n = stringArray.length();
            while (n2 < n) {
                char ch = stringArray.charAt(n2);
                ++n2;
                lineLen += this.fontMetrics.charWidth(ch);
            }
            if (lineLen <= totalWidth) continue;
            totalWidth = lineLen;
        }
        GlStateManager.bindTexture((int)this.fontTextureID);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.color4f((float)((float)rgba.getRed() / 255.0f), (float)((float)rgba.getGreen() / 255.0f), (float)((float)rgba.getBlue() / 255.0f), (float)((float)rgba.getAlpha() / 255.0f));
        stringArray = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)stringToDraw, stringArray, false, 0, 6, null)) {
            int n3;
            Object object = textAlignment;
            n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    n3 = -(this.fontMetrics.stringWidth(line) / 2);
                    break;
                }
                case 2: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = -this.fontMetrics.stringWidth(line);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            drawX = n3;
            object = line;
            n = 0;
            int n4 = ((String)object).length();
            while (n < n4) {
                CharacterGlyph characterGlyph2;
                char currentChar = ((String)object).charAt(n);
                ++n;
                CharacterGlyph characterGlyph3 = this.glyphs.get(Character.valueOf(currentChar));
                if (characterGlyph3 == null) {
                    CharacterGlyph characterGlyph4 = this.glyphs.get(Character.valueOf('?'));
                    Intrinsics.checkNotNull(characterGlyph4);
                    characterGlyph2 = characterGlyph4;
                } else {
                    characterGlyph2 = characterGlyph3;
                }
                characterGlyph = characterGlyph2;
                this.drawQuad((float)drawX * guiScale + x, (float)drawY * guiScale + y, (float)(drawX + characterGlyph.getWidth()) * guiScale + x, (float)(drawY + characterGlyph.getHeight()) * guiScale + y, characterGlyph.getStoredX(), characterGlyph.getStoredY(), (float)characterGlyph.getStoredX() + (float)characterGlyph.getWidth(), (float)characterGlyph.getStoredY() + (float)characterGlyph.getHeight());
                drawX += characterGlyph.getWidth();
            }
            drawY += this.height;
        }
        tessellator.func_78381_a();
    }

    private final void drawQuad(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2) {
        float f = drawX2 - drawX;
        boolean bl = false;
        float drawWidth = Math.abs(f);
        float f2 = drawY2 - drawY;
        boolean bl2 = false;
        float drawHeight = Math.abs(f2);
        float f3 = srcX2 - srcX;
        boolean bl3 = false;
        float srcWidth = Math.abs(f3);
        float f4 = srcY2 - srcY;
        boolean bl4 = false;
        float srcHeight = Math.abs(f4);
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a((double)(srcX / (float)this.textureWidth), (double)((srcY + srcHeight) / (float)this.textureHeight)).func_181675_d();
        bufferBuilder.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a((double)((srcX + srcWidth) / (float)this.textureWidth), (double)((srcY + srcHeight) / (float)this.textureHeight)).func_181675_d();
        bufferBuilder.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a((double)((srcX + srcWidth) / (float)this.textureWidth), (double)(srcY / (float)this.textureHeight)).func_181675_d();
        bufferBuilder.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a((double)(srcX / (float)this.textureWidth), (double)(srcY / (float)this.textureHeight)).func_181675_d();
    }

    public final int getWidth(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return MathKt.roundToInt((float)this.fontMetrics.stringWidth(string) * this.calcGuiScale());
    }

    /*
     * WARNING - void declaration
     */
    public final int getHeight(@NotNull String string) {
        void $this$count$iv;
        Intrinsics.checkNotNullParameter(string, "string");
        CharSequence charSequence = string;
        float f = (float)this.fontMetrics.getHeight() * this.calcGuiScale();
        boolean $i$f$count = false;
        int count$iv = 0;
        void var5_6 = $this$count$iv;
        for (int i = 0; i < var5_6.length(); ++i) {
            char element$iv;
            char it = element$iv = var5_6.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n = count$iv;
        return MathKt.roundToInt(f * (float)(n + 1));
    }

    public static /* synthetic */ int getHeight$default(TrueTypeFont trueTypeFont, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return trueTypeFont.getHeight(string);
    }

    public final void destroy() {
        IntBuffer scratch = BufferUtils.createIntBuffer((int)1);
        scratch.put(0, this.fontTextureID);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glDeleteTextures((IntBuffer)scratch);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        logger = LogManager.getLogger();
        Iterable $this$map$iv = new IntRange(6, 12);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double d = 2.0;
            boolean bl2 = false;
            Integer n2 = (int)Math.pow(d, (double)it);
            collection.add(n2);
        }
        validTextureSizes = (List)var3_3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont$CharacterGlyph;", "", "width", "", "height", "storedX", "storedY", "(IIII)V", "getHeight", "()I", "setHeight", "(I)V", "getStoredX", "setStoredX", "getStoredY", "setStoredY", "getWidth", "setWidth", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "afraidofthedark"})
    private static final class CharacterGlyph {
        private int width;
        private int height;
        private int storedX;
        private int storedY;

        public CharacterGlyph(int width, int height, int storedX, int storedY) {
            this.width = width;
            this.height = height;
            this.storedX = storedX;
            this.storedY = storedY;
        }

        public /* synthetic */ CharacterGlyph(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getStoredX() {
            return this.storedX;
        }

        public final void setStoredX(int n) {
            this.storedX = n;
        }

        public final int getStoredY() {
            return this.storedY;
        }

        public final void setStoredY(int n) {
            this.storedY = n;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        public final int component3() {
            return this.storedX;
        }

        public final int component4() {
            return this.storedY;
        }

        @NotNull
        public final CharacterGlyph copy(int width, int height, int storedX, int storedY) {
            return new CharacterGlyph(width, height, storedX, storedY);
        }

        public static /* synthetic */ CharacterGlyph copy$default(CharacterGlyph characterGlyph, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = characterGlyph.width;
            }
            if ((n5 & 2) != 0) {
                n2 = characterGlyph.height;
            }
            if ((n5 & 4) != 0) {
                n3 = characterGlyph.storedX;
            }
            if ((n5 & 8) != 0) {
                n4 = characterGlyph.storedY;
            }
            return characterGlyph.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "CharacterGlyph(width=" + this.width + ", height=" + this.height + ", storedX=" + this.storedX + ", storedY=" + this.storedY + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + Integer.hashCode(this.storedX);
            result = result * 31 + Integer.hashCode(this.storedY);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CharacterGlyph)) {
                return false;
            }
            CharacterGlyph characterGlyph = (CharacterGlyph)other;
            if (this.width != characterGlyph.width) {
                return false;
            }
            if (this.height != characterGlyph.height) {
                return false;
            }
            if (this.storedX != characterGlyph.storedX) {
                return false;
            }
            return this.storedY == characterGlyph.storedY;
        }

        public CharacterGlyph() {
            this(0, 0, 0, 0, 15, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont$Companion;", "", "()V", "DEFAULT_CHARACTER", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "validTextureSizes", "", "", "loadImage", "bufferedImage", "Ljava/awt/image/BufferedImage;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        private final int loadImage(BufferedImage bufferedImage) {
            try {
                Object $this$forEach$iv;
                int width = bufferedImage.getWidth();
                int height = bufferedImage.getHeight();
                int bitsPerPixel = bufferedImage.getColorModel().getPixelSize();
                ByteBuffer byteBuffer = null;
                DataBuffer db = bufferedImage.getData().getDataBuffer();
                if (db instanceof DataBufferInt) {
                    Object object = ByteBuffer.allocateDirect(width * height * (bitsPerPixel / 8)).order(ByteOrder.nativeOrder());
                    Intrinsics.checkNotNullExpressionValue(object, "allocateDirect(width * height * (bitsPerPixel / 8)).order(ByteOrder.nativeOrder())");
                    byteBuffer = object;
                    object = ((DataBufferInt)db).getData();
                    Intrinsics.checkNotNullExpressionValue(object, "db.data");
                    $this$forEach$iv = object;
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv;
                    int n = ((Object)object2).length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv;
                        Object it = element$iv = object2[i];
                        boolean bl = false;
                        byteBuffer.putInt((int)it);
                    }
                } else {
                    $this$forEach$iv = ByteBuffer.allocateDirect(width * height * (bitsPerPixel / 8)).order(ByteOrder.nativeOrder());
                    Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "allocateDirect(width * height * (bitsPerPixel / 8)).order(ByteOrder.nativeOrder())");
                    byteBuffer = $this$forEach$iv;
                    if (db == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.awt.image.DataBufferByte");
                    }
                    byteBuffer.put(((DataBufferByte)db).getData());
                }
                byteBuffer.flip();
                IntBuffer textureBuffer = GLAllocation.func_74524_c((int)4).asIntBuffer();
                GL11.glGenTextures((IntBuffer)textureBuffer);
                int textureId = textureBuffer.get(0);
                GL11.glEnable((int)3553);
                GlStateManager.bindTexture((int)textureId);
                GlStateManager.texParameter((int)3553, (int)10242, (int)10496);
                GlStateManager.texParameter((int)3553, (int)10243, (int)10496);
                GlStateManager.texParameter((int)3553, (int)10240, (int)9728);
                GlStateManager.texParameter((int)3553, (int)10241, (int)9728);
                GlStateManager.texEnv((int)8960, (int)8704, (float)8448.0f);
                GlStateManager.pixelStore((int)3314, (int)0);
                GlStateManager.pixelStore((int)3315, (int)0);
                GlStateManager.pixelStore((int)3316, (int)0);
                GlStateManager.pixelStore((int)3317, (int)(bitsPerPixel / 8));
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                GL11.glDisable((int)3553);
                return textureId;
            }
            catch (Exception e) {
                logger.error("Could not allocate an OpenGL texture!", (Throwable)e);
                int n = -1;
                boolean bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlignment.values().length];
            nArray[TextAlignment.ALIGN_CENTER.ordinal()] = 1;
            nArray[TextAlignment.ALIGN_LEFT.ordinal()] = 2;
            nArray[TextAlignment.ALIGN_RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

